/**
 * Description: 客户项目信息数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 客户项目信息数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public class CustomerProjectEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 置业顾问姓名
     */
    @Length(max = 50, message = "长度需要大于0且小于50")
    private String consultantName;

    /**
     * 客户状态 0 未约看 1 约看、2 到访、3 认筹、4 认购、5 签约、6 退房
     */
    @NotNull
    private Integer status;

    /**
     * 置业顾问手机
     */
    private String consultantPhone;

    /**
     * 是否重客 1 是 0 否
     */
    @NotNull
    private Integer isRepeat;

    /**
     * 案场报备状态 1案场已报备 0案场未报备
     */
    private Integer recordedStatus;

    /**
     * 约看时间
     */
    private java.util.Date recordedTime;

    /**
     * 到访次数
     */
    private Integer visitTime;

    /**
     * 贷款状态 0未办理，1申请中，2已下款，3被拒绝，4全款支付
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String loanStatus;

    /**
     * 创建时间
     */
    @NotNull
    private java.util.Date createTime;

    @NotNull
    private java.util.Date occurTime;

    public Date getOccurTime() {
        return occurTime;
    }

    public void setOccurTime(Date occurTime) {
        this.occurTime = occurTime;
    }

    public long occurTimeToCrm;

    public long getOccurTimeToCrm() {
        return occurTimeToCrm;
    }

    public void setOccurTimeToCrm(long occurTimeToCrm) {
        this.occurTimeToCrm = occurTimeToCrm;
    }

    /**
     * 项目ID
     */
    @NotNull
    private Integer projectId;

    @NotNull
    private String contract;

    /**
     * 备注信息
     */
    @Length(max = 1000, message = "长度需要大于0且小于1000")
    private String remark;

    /**
     * 客户ID
     */
    @NotNull
    private Integer customerId;

    /**
     * 需求面积
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String requireArea;

    /**
     * 需求房号
     */
    @Length(max = 250, message = "长度需要大于0且小于250")
    private String requireHouse;

    /**
     * 需求房型
     */
    @Length(max = 250, message = "长度需要大于0且小于250")
    private String requireHouseType;

    /**
     * 总价预算
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String requirePrice;

    /**
     * 更新日期
     */
    @NotNull
    private java.util.Date updateTime;

    /**
     * 修改人
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String updater;

    @Length(max = 12, message = "长度需要大于0且小于11")
    private String customerPhone;

    private String houseName;

    private String creater;

    private String projectName;
    //最后变更状态时间
    private Date lastChangeStatusTime;

    private int jgStatus;

    //columns END

    public Date getLastChangeStatusTime() {
        return lastChangeStatusTime;
    }

    public void setLastChangeStatusTime(Date lastChangeStatusTime) {
        this.lastChangeStatusTime = lastChangeStatusTime;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCreater() {
        return creater;
    }

    public void setCreater(String creater) {
        this.creater = creater;
    }

    public String getHouseName() {
        return houseName;
    }

    public void setHouseName(String houseName) {
        this.houseName = houseName;
    }

    public String getContract() {
        return contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }

    public String getCustomerPhone() {
        return customerPhone;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    /**
     * 获取置业顾问姓名
     *
     * @return 置业顾问姓名
     */
    public String getConsultantName() {
        return this.consultantName;
    }

    /**
     * 设置置业顾问姓名
     *
     * @param consultantName 置业顾问姓名
     */
    public void setConsultantName(String consultantName) {
        this.consultantName = consultantName;
    }

    /**
     * 获取客户状态 1约看、2到访、3认筹、4认购、5签约、6退房
     *
     * @return 客户状态 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置客户状态 1约看、2到访、3认筹、4认购、5签约、6退房
     *
     * @param status 客户状态 1约看、2到访、3认筹、4认购、5签约、6退房
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取置业顾问手机
     *
     * @return 置业顾问手机
     */
    public String getConsultantPhone() {
        return this.consultantPhone;
    }

    /**
     * 设置置业顾问手机
     *
     * @param consultantPhone 置业顾问手机
     */
    public void setConsultantPhone(String consultantPhone) {
        this.consultantPhone = consultantPhone;
    }

    /**
     * 获取是否重客 1 是 0 否
     *
     * @return 是否重客 1 是 0 否
     */
    public Integer getIsRepeat() {
        return this.isRepeat;
    }

    /**
     * 设置是否重客 1 是 0 否
     *
     * @param isRepeat 是否重客 1 是 0 否
     */
    public void setIsRepeat(Integer isRepeat) {
        this.isRepeat = isRepeat;
    }

    /**
     * 获取案场报备状态 1案场已报备 0案场未报备
     *
     * @return 案场报备状态 1案场已报备 0案场未报备
     */
    public Integer getRecordedStatus() {
        return this.recordedStatus;
    }

    /**
     * 设置案场报备状态 1案场已报备 0案场未报备
     *
     * @param recordedStatus 案场报备状态 1案场已报备 0案场未报备
     */
    public void setRecordedStatus(Integer recordedStatus) {
        this.recordedStatus = recordedStatus;
    }

    /**
     * 设置约看时间字符串格式
     *
     * @param recordedTime 约看时间
     */
    public void setRecordedTimeStr(String recordedTime) {
        if (!com.house365.web.util.StringUtils.isBlank(recordedTime)) {
            try {
                this.recordedTime = java.text.DateFormat.getDateTimeInstance().parse(recordedTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取约看时间
     *
     * @return 约看时间
     */
    public java.util.Date getRecordedTime() {
        return this.recordedTime;
    }

    /**
     * 设置约看时间
     *
     * @param recordedTime 约看时间
     */
    public void setRecordedTime(java.util.Date recordedTime) {
        this.recordedTime = recordedTime;
    }

    /**
     * 获取到访次数
     *
     * @return 到访次数
     */
    public Integer getVisitTime() {
        return this.visitTime;
    }

    /**
     * 设置到访次数
     *
     * @param visitTime 到访次数
     */
    public void setVisitTime(Integer visitTime) {
        this.visitTime = visitTime;
    }

    /**
     * 获取贷款状态 0未办理，1申请中，2已下款，3被拒绝，4全款支付
     *
     * @return 贷款状态 0未办理，1申请中，2已下款，3被拒绝，4全款支付
     */
    public String getLoanStatus() {
        return this.loanStatus;
    }

    /**
     * 设置贷款状态 0未办理，1申请中，2已下款，3被拒绝，4全款支付
     *
     * @param loanStatus 贷款状态 0未办理，1申请中，2已下款，3被拒绝，4全款支付
     */
    public void setLoanStatus(String loanStatus) {
        this.loanStatus = loanStatus;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取项目ID
     *
     * @return 项目ID
     */
    public Integer getProjectId() {
        return this.projectId;
    }

    /**
     * 设置项目ID
     *
     * @param projectId 项目ID
     */
    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * 获取备注信息
     *
     * @return 备注信息
     */
    public String getRemark() {
        return this.remark;
    }

    /**
     * 设置备注信息
     *
     * @param remark 备注信息
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 获取客户ID
     *
     * @return 客户ID
     */
    public Integer getCustomerId() {
        return this.customerId;
    }

    /**
     * 设置客户ID
     *
     * @param customerId 客户ID
     */
    public void setCustomerId(Integer customerId) {
        this.customerId = customerId;
    }

    /**
     * 获取需求面积
     *
     * @return 需求面积
     */
    public String getRequireArea() {
        return this.requireArea;
    }

    /**
     * 设置需求面积
     *
     * @param requireArea 需求面积
     */
    public void setRequireArea(String requireArea) {
        this.requireArea = requireArea;
    }

    /**
     * 获取需求房号
     *
     * @return 需求房号
     */
    public String getRequireHouse() {
        return this.requireHouse;
    }

    /**
     * 设置需求房号
     *
     * @param requireHouse 需求房号
     */
    public void setRequireHouse(String requireHouse) {
        this.requireHouse = requireHouse;
    }

    /**
     * 获取需求房型
     *
     * @return 需求房型
     */
    public String getRequireHouseType() {
        return this.requireHouseType;
    }

    /**
     * 设置需求房型
     *
     * @param requireHouseType 需求房型
     */
    public void setRequireHouseType(String requireHouseType) {
        this.requireHouseType = requireHouseType;
    }

    /**
     * 获取总价预算
     *
     * @return 总价预算
     */
    public String getRequirePrice() {
        return this.requirePrice;
    }

    /**
     * 设置总价预算
     *
     * @param requirePrice 总价预算
     */
    public void setRequirePrice(String requirePrice) {
        this.requirePrice = requirePrice;
    }

    /**
     * 设置更新日期字符串格式
     *
     * @param updateTime 更新日期
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取更新日期
     *
     * @return 更新日期
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置更新日期
     *
     * @param updateTime 更新日期
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取修改人
     *
     * @return 修改人
     */
    public String getUpdater() {
        return this.updater;
    }

    /**
     * 设置修改人
     *
     * @param updater 修改人
     */
    public void setUpdater(String updater) {
        this.updater = updater;
    }

    public int getJgStatus() {
        return jgStatus;
    }

    public void setJgStatus(int jgStatus) {
        this.jgStatus = jgStatus;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("ConsultantName",
                                                                                                      getConsultantName()).append(
            "Status", getStatus()).append("ConsultantPhone", getConsultantPhone()).append("IsRepeat",
                                                                                          getIsRepeat()).append(
            "RecordedStatus", getRecordedStatus()).append("RecordedTime", getRecordedTime()).append("VisitTime",
                                                                                                    getVisitTime()).append(
            "LoanStatus", getLoanStatus()).append("CreateTime", getCreateTime()).append("ProjectId",
                                                                                        getProjectId()).append("Remark",
                                                                                                               getRemark()).append(
            "CustomerId", getCustomerId()).append("RequireArea", getRequireArea()).append("RequireHouse",
                                                                                          getRequireHouse()).append(
            "RequireHouseType", getRequireHouseType()).append("RequirePrice", getRequirePrice()).append("UpdateTime",
                                                                                                        getUpdateTime()).append(
            "Updater", getUpdater()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CustomerProjectEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CustomerProjectEntity other = (CustomerProjectEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

