/**
 * Description: 项目日报-城市部门配置数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-08-09 下午 14:31:30
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-08-09   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 项目日报-城市部门配置数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-08-09
 * @see
 * @since 1.0
 */
public class CityDepConfigEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * city
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String city;

    /**
     * dept
     */
    @Length(max = 400, message = "长度需要大于0且小于45")
    private String dept;

    /**
     * 设置city
     * @param city city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 获取city
     * @return city
     */
    public String getCity() {
        return this.city;
    }

    /**
     * 设置dept
     * @param dept dept
     */
    public void setDept(String dept) {
        this.dept = dept;
    }

    /**
     * 获取dept
     * @return dept
     */
    public String getDept() {
        return this.dept;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("City",
                                                                                                      getCity()).append(
            "Dept", getDept()).toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CityDepConfigEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CityDepConfigEntity other = (CityDepConfigEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

