/**
 * Description: 直销人员楼盘推荐业务实现类
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-22 下午 13:57:27
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-22   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.UserProjectRecommendEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IUserProjectRecommendDao;
import com.house365.ws.service.interfaces.IUserProjectRecommendService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 直销人员楼盘推荐业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-22
 * @see
 * @since 1.0
 */
@Service("userProjectRecommendService")
public class UserProjectRecommendServiceImpl<T extends UserProjectRecommendEntity> extends DefaultServiceImpl<T> implements IUserProjectRecommendService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IUserProjectRecommendDao<T> userProjectRecommendDao;

    @Override
    protected Dao<T> getDao() {
        return userProjectRecommendDao;
    }
}