/**
 * Description: 统计信息业务实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-27 下午 15:54:06
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-27   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.StatisticEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IStatisticDao;
import com.house365.ws.service.interfaces.IStatisticService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 统计信息业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-27
 * @see
 * @since 1.0
 */
@Service("statisticService")
public class StatisticServiceImpl<T extends StatisticEntity> extends DefaultServiceImpl<T> implements IStatisticService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IStatisticDao<T> statisticDao;

    @Override
    protected Dao<T> getDao() {
        return statisticDao;
    }

    @Override
    public List getDistinctReportName(String city) {
        return statisticDao.getDistinctReportName(city);
    }
}
