/**
 * Description: 抢客业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 上午 09:44:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.common.HGSConstant;
import com.house365.beans.entity.RushCustomerEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.cached.RedisUtilsInterface;
import com.house365.ws.dao.interfaces.IRushCustomerDao;
import com.house365.ws.service.interfaces.IRushCustomerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 抢客业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
@Service("rushCustomerService")
public class RushCustomerServiceImpl<T extends RushCustomerEntity> extends DefaultServiceImpl<T> implements IRushCustomerService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IRushCustomerDao<T> rushCustomerDao;
    @Autowired
    private RedisUtilsInterface redisUtils;

    @Override
    protected Dao<T> getDao() {
        return rushCustomerDao;
    }

    @Override
    public Integer createRushCustomer(
            RushCustomerEntity rushCustomerEntity) throws Exception {

        //保存客户
        Integer customerId = save((T) rushCustomerEntity);
        //抢客客户入redis缓存
        redisUtils.pushIntegerIntoRedisList(HGSConstant.RUSH_CUSTOMER_LEFT_LIST + customerId, 1);
        return customerId;
    }

    @Override
    public List<RushCustomerEntity> queryAllShow(QueryParams<?> queryParams) {
        return rushCustomerDao.queryAllShow(queryParams);
    }

    @Override
    public int queryAllShowCount(QueryParams<?> queryParams) {
        return rushCustomerDao.queryAllShowCount(queryParams);
    }
}