/**
 * Description: ProjectSaler业务实现类
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-23 下午 17:14:15
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-23   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.ProjectSalerEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IProjectSalerDao;
import com.house365.ws.service.interfaces.IProjectSalerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ProjectSaler业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-23
 * @see
 * @since 1.0
 */
@Service("projectSalerService")
public class ProjectSalerServiceImpl<T extends ProjectSalerEntity> extends DefaultServiceImpl<T> implements IProjectSalerService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IProjectSalerDao<T> projectSalerDao;

    @Override
    protected Dao<T> getDao() {
        return projectSalerDao;
    }

    @Override
    public List<UserEntity> queryUserByPrjId(Integer projectId, String city) {
        Map<String, Object> params = new HashMap<>();
        params.put("projectId", projectId);
        params.put("city", city);
        return projectSalerDao.queryUserByPrjId(params);
    }

    @Override
    public void deleteByProjectId(Integer projectId) {
        Map<String, Object> params = new HashMap<>();
        params.put("projectId", projectId);
        projectSalerDao.deleteByProjectId(params);
    }

    @Override
    public Integer getUserByHouse(Integer houseId, String channel, String city) {
        Integer userId = null;
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("EQ_projectId", houseId);
        queryMap.put("LIKE_channel", channel);
        queryMap.put("EQ_city", city);
        QueryParams userParams = new QueryParams();
        userParams.setSearchParams(queryMap);
        List<ProjectSalerEntity> salerEntities = (List<ProjectSalerEntity>) projectSalerDao.queryAll(userParams);
        if (salerEntities != null && salerEntities.size() != 0) {
            userId = salerEntities.get(0).getUserId();
        }
        return userId;
    }

    @Override
    public ProjectSalerEntity getSalerByHouse(Integer houseId, String channel, String city) {
        ProjectSalerEntity salerEntity = null;
        Map<String, Object> queryMap = new HashMap<>();
        queryMap.put("EQ_projectId", houseId);
        queryMap.put("LIKE_channel", channel);
        queryMap.put("EQ_city", city);
        QueryParams userParams = new QueryParams();
        userParams.setSearchParams(queryMap);
        List<ProjectSalerEntity> salerEntities = (List<ProjectSalerEntity>) projectSalerDao.queryAll(userParams);
        if (salerEntities != null && salerEntities.size() != 0) {
            salerEntity = salerEntities.get(0);
        }
        return salerEntity;
    }

    @Override
    public void deleteByUserId(String userId) {
        projectSalerDao.deleteByUserId(userId);
    }

    @Override
    public List<ProjectSalerEntity> queryAllList() {
        return projectSalerDao.queryAllList();
    }
}
