/**
 * Description: MarketBuildingRel业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:20:56
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.MarketBuildingRelEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.IMarketBuildingRelDao;
import com.house365.ws.service.interfaces.IMarketBuildingRelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * MarketBuildingRel业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
@Service("marketBuildingRelService")
public class MarketBuildingRelServiceImpl<T extends MarketBuildingRelEntity> extends DefaultServiceImpl<T> implements IMarketBuildingRelService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IMarketBuildingRelDao<T> marketBuildingRelDao;

    @Override
    protected Dao<T> getDao() {
        return marketBuildingRelDao;
    }

    @Override
    public void deleteByActiveId(Integer id) {
        marketBuildingRelDao.deleteByActiveId(id);
    }
}
