package com.house365.ws.service.impl;

import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.CustomerProjectEntity;
import com.house365.beans.entity.DictionaryEntity;
import com.house365.ws.dao.mapper.CustomerMapper;
import com.house365.ws.dao.mapper.CustomerMergeMapper;
import com.house365.ws.dao.mapper.CustomerProjectMapper;
import com.house365.ws.service.interfaces.ICheckNoCallCustomerNoLimit;
import com.house365.ws.service.interfaces.ICustomerService;
import com.house365.ws.util.OperateLogUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author 回公海定时
 */
@Service("checkNoLimitImpl")
public class CheckNoLimitImpl implements ICheckNoCallCustomerNoLimit {

    @Autowired
    private ICustomerService<CustomerEntity> customerService;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private OperateLogUtils logUtils;
    @Autowired
    private CustomerMergeMapper customermergemapper;
    @Autowired
    private CustomerProjectMapper customerProjectMapper;

    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void backToSea() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String time = sdf.format(date);
        //先取城市对应的参数值
        Map<String, Object> parammap = new HashMap<>(10);
        parammap.put("dicKey", "customer.remove.days.nolimit");
        List<DictionaryEntity> cityNoCalLss = customerService.getNoApproximateConfig(parammap);
        if (CollectionUtils.isNotEmpty(cityNoCalLss)) {
            for (DictionaryEntity entity : cityNoCalLss) {
                String city = entity.getCity();
                String days = entity.getDicValue();
                Map<String, Object> map = new HashMap<>(10);
                map.put("city", city);
                map.put("days", days);
                map.put("isRecycled", "1");
                map.put("date", time);
                map.put("updaterId", "cron");

                // 添加客户移入公海日志
                List<CustomerEntity> list = customerMapper.backToSeaCustomerNoLimit(map);
                List<Integer> ids = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(list)) {
                    for (CustomerEntity c : list) {
                        ids.add(c.getId());
                    }
                    map.put("ids", ids);
                    //超过N天无约看记录回公海
                    customerMapper.noApproximateBackToSea(map);
                    //删除回公海的客户
                    customermergemapper.clearCustomerMerge(map);
                    for (CustomerEntity c : list) {
                        logUtils.saveCustomerLog(c, 6, 0, "不限制约看定时接口");
                    }

                }
            }
        }
    }

    /**
     * N天无回访入公海（且未达到到访状态）
     */
    @Override
    @Transactional(rollbackFor = {Exception.class})
    public void backNoVisitToSea() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String time = sdf.format(date);
        //先取城市对应的参数值
        Map<String, Object> paramMap = new HashMap<>(10);
        paramMap.put("dicKey", "customer.remove.days.noVisit");
        List<DictionaryEntity> cityNoCalLss = customerService.getNoApproximateConfig(paramMap);
        if (CollectionUtils.isNotEmpty(cityNoCalLss)) {
            for (DictionaryEntity entity : cityNoCalLss) {
                String city = entity.getCity();
                String days = entity.getDicValue();
                Map<String, Object> map = new HashMap<>(10);
                map.put("city", city);
                map.put("days", days);
                map.put("isRecycled", "1");
                map.put("date", time);
                map.put("updaterId", "cron");

                // 添加客户移入公海日志
                List<CustomerEntity> list = customerMapper.backToSeaCustomerNoLimit(map);

                //合并客户有一条满足到访，其关联客户都不回公海
                List<CustomerEntity> daoList = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(list)) {
                    for (CustomerEntity c : list) {
                        int id = c.getId();
                        Map<String, Object> searchMap = new HashMap<>(10);
                        searchMap.put("customerIdNew", id);
                        searchMap.put("isVisit", 1);
                        searchMap.put("limit", 1);
                        List<CustomerProjectEntity> cpList = customerProjectMapper.queryByConditions(searchMap);
                        //有到访则过滤
                        if (CollectionUtils.isNotEmpty(cpList)) {
                            daoList.add(c);
                        }
                    }
                }

                if (CollectionUtils.isNotEmpty(daoList)) {
                    for (CustomerEntity e : daoList) {
                        String phone = e.getPhone();
                        int managerId = e.getManagerId();
                        Iterator<CustomerEntity> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            CustomerEntity c = iterator.next();
                            String phoneNew = c.getPhone();
                            int managerIdNew = c.getManagerId();
                            if (phoneNew.equals(phone) && managerId == managerIdNew) {
                                iterator.remove();
                            }
                        }
                    }
                }

                List<Integer> ids = new ArrayList<>();
                //过滤掉已约看的，只取未到访的客户

                if (CollectionUtils.isNotEmpty(list)) {
                    for (CustomerEntity c : list) {
                        ids.add(c.getId());
                    }
                    map.put("ids", ids);
                    //超过N天无约看记录回公海
                    customerMapper.noApproximateBackToSea(map);
                    //删除回公海的客户
                    customermergemapper.clearCustomerMerge(map);
                    for (CustomerEntity c : list) {
                        logUtils.saveCustomerLog(c, 6, 0, "N天无回访且未到访接口");
                    }
                }
            }
        }
    }

}
