package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.UserEvaluateEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.service.interfaces.IUserService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service("reviewEvaluation")
public class ReviewEvaluationImpl implements IReviewEvaluation {

    private static final Logger LOGGER = LoggerFactory.getLogger(ReviewEvaluationImpl.class);

    @Autowired
    private IUserService userService;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<Boolean> response = new House365RestResponse<>();
        // 业务层统一处理
        try {
            House365RestObject<Boolean> data = doBusiness(map);
            response.setData(data);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        String result = JSONObject.fromObject(response).toString();
        return result;
    }

    /**
     * 业务层统逻辑处理
     */
    private House365RestObject<Boolean> doBusiness(Map<String, Object> map) throws Exception {
        // 返回Json对象
        House365RestObject object = new House365RestObject();
        object.setEntity(Boolean.FALSE);
        String evid = getMapValueByKey("id", map, "");
        UserEvaluateEntity uee = new UserEvaluateEntity();
        uee.setId(Integer.valueOf(evid));
        uee.setCheckStatus("1");//审核状态 0：待审核；1：审核通过；2：审核不通过
        try {
            userService.reviewStatus(uee);
            object.setEntity(Boolean.TRUE);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
        return object;
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }
}
