package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.BaseAttachment;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.po.UserPo;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.dao.mapper.UserMapper;
import com.house365.ws.service.interfaces.IAttachmentService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author
 * Created by Administrator on 2019/1/9.
 */
@Service("getUserInfo")
public class GetUserInfoImpl implements IGetUserInfo {

    private static final Logger logger = LoggerFactory.getLogger(GetUserInfoImpl.class);

    @Autowired
    private UserMapper userMapper;
    @Autowired
    private IAttachmentService attachmentService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<UserPo> response = new House365RestResponse<>();
        House365RestObject<UserPo> restObject = new House365RestObject<>();
        try {
            UserPo user = new UserPo();
            UserEntity entity = new UserEntity();
            String userId = getMapValueByKey("userId", map, "");
            String userName = getMapValueByKey("userName", map, "");
            String telephone = getMapValueByKey("telephone", map, "");
            if (StringUtils.isNotBlank(userId) && !"0".equals(userId)) {
                entity = userMapper.getById(Integer.parseInt(userId));
            } else {
                Map<String, Object> searchMap = new HashMap<>(10);
                searchMap.put("userName", userName);
                searchMap.put("telephone", telephone);
                List<UserEntity> list = userMapper.queryByConditions(searchMap);
                if (CollectionUtils.isNotEmpty(list)) {
                    entity = list.get(0);
                }
            }
            if(entity != null) {
                user.setId(entity.getId());
                //业务专长
                user.setGoodat(entity.getGoodat());
                //个人介绍
                user.setDescription(entity.getDescription());
                //个人400
                user.setHotlinephone(entity.getHotlinephone());
                List<BaseAttachment> headImg = attachmentService.queryByResourceIdAndResouceType(String.valueOf(userId), "hgs_user_headImg");
                List<BaseAttachment> fullImg = attachmentService.queryByResourceIdAndResouceType(String.valueOf(userId), "hgs_user_fullImg");

                if (CollectionUtils.isNotEmpty(headImg)) {
                    user.setHeadImgURL(headImg.get(0).getRemotePath());
                }
                if (CollectionUtils.isNotEmpty(fullImg)) {
                    user.setFullImgURL(fullImg.get(0).getRemotePath());
                }
                restObject.setEntity(user);
                response.setData(restObject);
                response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error("查询用户信息失败",e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        return JSONObject.fromObject(response).toString();
    }

    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
        // Do nothing because of X and Y.
    }
}
