package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.VersionEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.VersionListRequest;
import com.house365.ws.beans.request.VersionRequest;
import com.house365.ws.beans.response.VersionListResponse;
import com.house365.ws.beans.response.VersionResponse;
import com.house365.ws.interfaces.server.IVersion;
import com.house365.ws.service.interfaces.IVersionService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("version")
public class VersionImpl implements IVersion {

    private static final Logger LOGGER = LoggerFactory.getLogger(VersionImpl.class);

    @Autowired
    IVersionService<VersionEntity> versionService;


    @Override
    public VersionResponse addVersion(VersionRequest request) {
        VersionResponse response = new VersionResponse();
        try {
            VersionEntity entity = request.getEntity();
            versionService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public void deleteVersionById(Integer id) {
        versionService.deleteVersionById(id);
    }

    @Override
    public VersionListResponse getAppVersionList(VersionListRequest request) {
        VersionListResponse response = new VersionListResponse();
        try {
            QueryParams<VersionEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<VersionEntity> version = versionService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(version);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
