/**
 * Description: 角色权限关联WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:21
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.RolePermissionEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.RolePermissionListRequest;
import com.house365.ws.beans.request.RolePermissionRequest;
import com.house365.ws.beans.response.RolePermissionListResponse;
import com.house365.ws.beans.response.RolePermissionResponse;
import com.house365.ws.interfaces.server.IRolePermission;
import com.house365.ws.service.interfaces.IRolePermissionService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * 角色权限关联WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
@Service("rolePermission")
public class RolePermissionImpl implements IRolePermission {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(RolePermissionImpl.class);

    /**
     * 角色权限关联服务对象
     */
    @Autowired
    private IRolePermissionService<RolePermissionEntity> rolePermissionService;

    /**
     * 角色权限关联列表查询
     *
     * @param request 角色权限关联列表查询请求
     * @return 角色权限关联列表查询响应
     */
    @Override
    public RolePermissionListResponse getRolePermissionList(RolePermissionListRequest request) {
        RolePermissionListResponse response = new RolePermissionListResponse();
        try {
            QueryParams<RolePermissionEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<RolePermissionEntity> rolePermissions = rolePermissionService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(rolePermissions);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存角色权限关联
     *
     * @param request 角色权限关联请求
     * @return 保存角色权限关联响应
     */
    @Override
    public RolePermissionResponse addRolePermission(RolePermissionRequest request) {
        RolePermissionResponse response = new RolePermissionResponse();
        try {
            RolePermissionEntity entity = request.getEntity();
            rolePermissionService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除角色权限关联通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除角色权限关联响应
     */
    @Override
    public RolePermissionResponse deleteRolePermissionById(Integer id) {
        RolePermissionResponse response = new RolePermissionResponse();
        try {
            rolePermissionService.deleteRolePermissionByRoleId(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改角色权限关联
     *
     * @param request 修改角色权限关联请求
     * @return 修改角色权限关联响应
     */
    @Override
    public RolePermissionResponse updateRolePermission(RolePermissionRequest request) {
        RolePermissionResponse response = new RolePermissionResponse();
        try {
            rolePermissionService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取角色权限关联
     *
     * @param id 唯一标识
     * @return 通过ID获取角色权限关联响应
     */
    @Override
    public RolePermissionResponse getRolePermissionById(Integer id) {
        RolePermissionResponse response = new RolePermissionResponse();
        try {
            RolePermissionEntity entity = rolePermissionService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public RolePermissionListResponse deleteRolePermissionByRoleId(Integer roleId) {
        RolePermissionListResponse response = new RolePermissionListResponse();
        try {
            rolePermissionService.deleteRolePermissionByRoleId(roleId);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
