/**
 * Description: DictionaryWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-08-30 下午 13:46:00
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-08-30   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.common.HGSConstant;
import com.house365.beans.entity.DictionaryEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.DictionaryListRequest;
import com.house365.ws.beans.request.DictionaryRequest;
import com.house365.ws.beans.response.DictionaryListResponse;
import com.house365.ws.beans.response.DictionaryResponse;
import com.house365.ws.cached.RedisUtilsInterface;
import com.house365.ws.dao.mapper.DictionaryMapper;
import com.house365.ws.interfaces.server.IDictionary;
import com.house365.ws.service.interfaces.IDictionaryService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * DictionaryWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-08-30
 * @see
 * @since 1.0
 */
@Service("dictionary")
public class DictionaryImpl implements IDictionary {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryImpl.class);

    /**
     * Dictionary服务对象
     */
    @Autowired
    private IDictionaryService<DictionaryEntity> cmDictionaryService;

    @Autowired
    private RedisUtilsInterface redisUtils;

    @Autowired
    private DictionaryMapper dictionaryMapper;

    /**
     * Dictionary列表查询
     *
     * @param request Dictionary列表查询请求
     * @return Dictionary列表查询响应
     */
    @Override
    public DictionaryListResponse getDictionaryList(DictionaryListRequest request) {
        DictionaryListResponse response = new DictionaryListResponse();
        try {
            QueryParams<DictionaryEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<DictionaryEntity> cmDictionarys = cmDictionaryService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cmDictionarys);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存Dictionary
     *
     * @param request Dictionary请求
     * @return 保存Dictionary响应
     */
    @Override
    public DictionaryResponse addDictionary(DictionaryRequest request) {
        DictionaryResponse response = new DictionaryResponse();
        try {
            DictionaryEntity entity = request.getEntity();
            cmDictionaryService.save(entity);
            redisUtils.deleteByKeyNew(HGSConstant.CACHE_DICT + entity.getDicKey());
            redisUtils.deleteByKeyNew(HGSConstant.CACHE_DICT_LIST + entity.getDicKey());
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除Dictionary通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除Dictionary响应
     */
    @Override
    public DictionaryResponse deleteDictionaryById(Integer id) {
        DictionaryResponse response = new DictionaryResponse();
        try {
            DictionaryEntity entity = cmDictionaryService.getById(id);
            cmDictionaryService.delete(id);
            redisUtils.deleteByKeyNew(HGSConstant.CACHE_DICT + entity.getDicKey());
            redisUtils.deleteByKeyNew(HGSConstant.CACHE_DICT_LIST + entity.getDicKey());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改Dictionary
     *
     * @param request 修改Dictionary请求
     * @return 修改Dictionary响应
     */
    @Override
    public DictionaryResponse updateDictionary(DictionaryRequest request) {
        DictionaryResponse response = new DictionaryResponse();
        try {
            cmDictionaryService.update(request.getEntity());
            redisUtils.deleteByKeyNew(HGSConstant.CACHE_DICT + request.getEntity().getDicKey());
            redisUtils.deleteByKeyNew(HGSConstant.CACHE_DICT_LIST + request.getEntity().getDicKey());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取Dictionary
     *
     * @param id 唯一标识
     * @return 通过ID获取Dictionary响应
     */
    @Override
    public DictionaryResponse getDictionaryById(Integer id) {
        DictionaryResponse response = new DictionaryResponse();
        try {
            DictionaryEntity entity = cmDictionaryService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public List<DictionaryEntity> getListByKey(String key) {
        return cmDictionaryService.getListByKey(key);
    }

    @Override
    public DictionaryEntity getByKey(String key) {
        return cmDictionaryService.getByKey(key);
    }

    @Override
    public List<DictionaryEntity> getNoApproximateConfig(Map<String, Object> map) {
        return dictionaryMapper.getNoApproximateConfig(map);
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
