/**
 * Description: 项目日报-城市部门配置WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-08-09 下午 14:31:30
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-08-09   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.CityDepConfigEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CityDepConfigListRequest;
import com.house365.ws.beans.request.CityDepConfigRequest;
import com.house365.ws.beans.response.CityDepConfigListResponse;
import com.house365.ws.beans.response.CityDepConfigResponse;
import com.house365.ws.interfaces.server.ICityDepConfig;
import com.house365.ws.service.interfaces.ICityDepConfigService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 项目日报-城市部门配置WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2020-08-09
 * @see
 * @since 1.0
 */
@Service("cityDepConfig")
public class CityDepConfigImpl implements ICityDepConfig {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(CityDepConfigImpl.class);

    /**
     * 项目日报-城市部门配置服务对象
     */
    @Autowired
    ICityDepConfigService<CityDepConfigEntity> cityDepConfigService;

    /**
     * 项目日报-城市部门配置列表查询
     *
     * @param request 项目日报-城市部门配置列表查询请求
     * @return 项目日报-城市部门配置列表查询响应
     */
    @Override
    public CityDepConfigListResponse getCityDepConfigList(CityDepConfigListRequest request) {
        CityDepConfigListResponse response = new CityDepConfigListResponse();
        try {
            QueryParams<CityDepConfigEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<CityDepConfigEntity> cityDepConfigs = cityDepConfigService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(cityDepConfigs);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存项目日报-城市部门配置
     *
     * @param request 项目日报-城市部门配置请求
     * @return 保存项目日报-城市部门配置响应
     */
    @Override
    public CityDepConfigResponse addCityDepConfig(CityDepConfigRequest request) {
        CityDepConfigResponse response = new CityDepConfigResponse();
        try {
            CityDepConfigEntity entity = request.getEntity();
            cityDepConfigService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除项目日报-城市部门配置通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除项目日报-城市部门配置响应
     */
    @Override
    public CityDepConfigResponse deleteCityDepConfigById(Integer id) {
        CityDepConfigResponse response = new CityDepConfigResponse();
        try {
            cityDepConfigService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改项目日报-城市部门配置
     *
     * @param request 修改项目日报-城市部门配置请求
     * @return 修改项目日报-城市部门配置响应
     */
    @Override
    public CityDepConfigResponse updateCityDepConfig(CityDepConfigRequest request) {
        CityDepConfigResponse response = new CityDepConfigResponse();
        try {
            cityDepConfigService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取项目日报-城市部门配置
     *
     * @param id 唯一标识
     * @return 通过ID获取项目日报-城市部门配置响应
     */
    @Override
    public CityDepConfigResponse getCityDepConfigById(Integer id) {
        CityDepConfigResponse response = new CityDepConfigResponse();
        try {
            CityDepConfigEntity entity = cityDepConfigService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
