/**
 * Description: 营销日报数据访问实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 下午 13:27:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.ReportMarketingEntity;
import com.house365.beans.po.ReportDailyPo;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.ReportMarketingFormVo;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IReportMarketingDao;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 营销日报数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
@Repository("reportMarketingDao")
public class ReportMarketingDaoImpl extends DefaultDaoImpl<ReportMarketingEntity> implements IReportMarketingDao<ReportMarketingEntity> {
    @Override
    public List<ReportDailyPo> getDailies(Map<String, Object> param) {
        return (List<ReportDailyPo>) this.getReadTemplate().queryForList(getStatement(), param);
    }

    @Override
    public List<ReportMarketingFormVo> statistic(QueryParams<?> params) {

        if (params != null && params.getPaging() != null) {
            int records = countStatistic(params);
            // 如果查询出符合条件的记录数为0，那么就直接返回一个空的List，因为后面的已经没有执行的必要
            if (records == 0) {
                return new ArrayList(0);
            }
            params.getPaging().setRecords(records);
        }

        return getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public List<ReportMarketingEntity> getByUserId(Map<String, Object> params) {

        return getReadTemplate().queryForList(getStatement(), params);
    }

    @Override
    public void updateByUserId(ReportMarketingEntity reportmarketingentity) {

        getReadTemplate().update(getStatement(), reportmarketingentity);
    }

    @Override
    public int countStatistic(QueryParams<?> params) {
        if (params == null) {
            return (Integer) this.getReadTemplate().queryForObject(getStatement());
        }
        return (Integer) this.getReadTemplate().queryForObject(getStatement(), params);
    }
}
