/**
 * Description: MarketBuildingRel数据访问实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:20:56
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.MarketBuildingRelEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IMarketBuildingRelDao;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * MarketBuildingRel数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
@Repository("marketBuildingRelDao")
public class MarketBuildingRelDaoImpl extends DefaultDaoImpl<MarketBuildingRelEntity> implements IMarketBuildingRelDao<MarketBuildingRelEntity> {
    @Override
    public void deleteByActiveId(Integer id) {
        getWriteTemplate().delete(getStatement(), id);
    }

    @Override
    public List<MarketBuildingRelEntity> getByActid(Integer activeId) {
        return getWriteTemplate().queryForList(getStatement(), activeId);
    }

}
