/**
 * Description: 客户项目信息数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.CustomerProjectEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.ICustomerProjectDao;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

/**
 * 客户项目信息数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
@Repository("customerProjectDao")
public class CustomerProjectDaoImpl extends DefaultDaoImpl<CustomerProjectEntity> implements ICustomerProjectDao<CustomerProjectEntity> {

    @Override
    public void updateName(Integer id, String projectName) {
        Map<String, Object> para = new HashMap();
        para.put("id", id);
        para.put("name", projectName);
        this.update(getStatement(), para);
    }

//    @Override
//    public List<CustomerProjectEntity> queryExcelList(Map<String, Object> queryParams){
//        return (List<CustomerProjectEntity>) getReadTemplate().queryForList(getStatement(), queryParams);
//    }
//
//    @Override
//    public List<CustomerProjectEntity> queryProlist(Map<String, Object> queryParams){
//        return (List<CustomerProjectEntity>) getReadTemplate().queryForList(getStatement(), queryParams);
//    }
}
