/**
 * Description: RushCustomerRuleDepartmentRelWS接口
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-10 上午 09:00:35
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-10   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.RushCustomerRuleDepartmentRelListRequest;
import com.house365.ws.beans.request.RushCustomerRuleDepartmentRelRequest;
import com.house365.ws.beans.response.RushCustomerRuleDepartmentRelListResponse;
import com.house365.ws.beans.response.RushCustomerRuleDepartmentRelResponse;


/**
 * RushCustomerRuleDepartmentRelWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-10
 * @see
 * @since 1.0
 */
public interface IRushCustomerRuleDepartmentRel extends IService {

    /**
     * RushCustomerRuleDepartmentRel列表查询
     *
     * @param request
     *            RushCustomerRuleDepartmentRel列表查询请求
     * @return RushCustomerRuleDepartmentRel列表查询响应
     */
    RushCustomerRuleDepartmentRelListResponse getRushCustomerRuleDepartmentRelList(
            RushCustomerRuleDepartmentRelListRequest request);

    /**
     * 保存RushCustomerRuleDepartmentRel
     *
     * @param request
     *            RushCustomerRuleDepartmentRel请求
     * @return 保存RushCustomerRuleDepartmentRel响应
     */
    RushCustomerRuleDepartmentRelResponse addRushCustomerRuleDepartmentRel(RushCustomerRuleDepartmentRelRequest request);

    /**
     * 删除RushCustomerRuleDepartmentRel通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除RushCustomerRuleDepartmentRel响应
     */
    RushCustomerRuleDepartmentRelResponse deleteRushCustomerRuleDepartmentRelById(Integer id);

    /**
     * 修改RushCustomerRuleDepartmentRel
     *
     * @param request
     *            修改RushCustomerRuleDepartmentRel请求
     * @return 修改RushCustomerRuleDepartmentRel响应
     */
    RushCustomerRuleDepartmentRelResponse updateRushCustomerRuleDepartmentRel(
            RushCustomerRuleDepartmentRelRequest request);

    /**
     * 通过ID获取RushCustomerRuleDepartmentRel
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取RushCustomerRuleDepartmentRel响应
     */
    RushCustomerRuleDepartmentRelResponse getRushCustomerRuleDepartmentRelById(Integer id);

    void saveDepartmentRuleRel(Integer ruleId, String departmentIds);

    void deleteDepartmentRuleRelByRuleId(Integer ruleId);
}
