/**
 * Description: 权限WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-14 下午 17:27:18
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.PermissionListRequest;
import com.house365.ws.beans.request.PermissionRequest;
import com.house365.ws.beans.response.PermissionListResponse;
import com.house365.ws.beans.response.PermissionResponse;


/**
 * 权限WS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public interface IPermission extends IService{

    /**
     * 权限列表查询
     * 
     * @param request
     *            权限列表查询请求
     * @return 权限列表查询响应
     */
    PermissionListResponse getPermissionList(
            PermissionListRequest request);

    /**
     * 保存权限
     * 
     * @param request
     *            权限请求
     * @return 保存权限响应
     */
    PermissionResponse addPermission(PermissionRequest request);

    /**
     * 删除权限通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除权限响应
     */
    PermissionResponse deletePermissionById(Integer id);

    /**
     * 修改权限
     * 
     * @param request
     *            修改权限请求
     * @return 修改权限响应
     */
    PermissionResponse updatePermission(
            PermissionRequest request);

    /**
     * 通过ID获取权限
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取权限响应
     */
    PermissionResponse getPermissionById(Integer id);
    
    /*PermissionListResponse queryAllByOrder(PermissionListRequest listRequest);*/
}
