/**
 * Description: MarketBuildingRelWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:20:56
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.MarketBuildingRelListRequest;
import com.house365.ws.beans.request.MarketBuildingRelRequest;
import com.house365.ws.beans.response.MarketBuildingRelListResponse;
import com.house365.ws.beans.response.MarketBuildingRelResponse;


/**
 * MarketBuildingRelWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
public interface IMarketBuildingRel extends IService {

    /**
     * MarketBuildingRel列表查询
     *
     * @param request MarketBuildingRel列表查询请求
     * @return MarketBuildingRel列表查询响应
     */
    MarketBuildingRelListResponse getMarketBuildingRelList(MarketBuildingRelListRequest request
    );

    /**
     * 保存MarketBuildingRel
     *
     * @param request MarketBuildingRel请求
     * @return 保存MarketBuildingRel响应
     */
    MarketBuildingRelResponse addMarketBuildingRel(MarketBuildingRelRequest request);

    /**
     * 删除MarketBuildingRel通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除MarketBuildingRel响应
     */
    MarketBuildingRelResponse deleteMarketBuildingRelById(Integer id);

    /**
     * 修改MarketBuildingRel
     *
     * @param request 修改MarketBuildingRel请求
     * @return 修改MarketBuildingRel响应
     */
    MarketBuildingRelResponse updateMarketBuildingRel(MarketBuildingRelRequest request);

    /**
     * 通过ID获取MarketBuildingRel
     *
     * @param id 唯一标识
     * @return 通过ID获取MarketBuildingRel响应
     */
    MarketBuildingRelResponse getMarketBuildingRelById(Integer id);

    void deleteByActiveId(Integer id);

}
