/**
 * Description: 客户活动来源WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-18 上午 08:58:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.CustomerSourceEntity;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CustomerSourceListRequest;
import com.house365.ws.beans.request.CustomerSourceRequest;
import com.house365.ws.beans.response.CustomerSourceListResponse;
import com.house365.ws.beans.response.CustomerSourceResponse;

import java.util.List;
import java.util.Map;


/**
 * 客户活动来源WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
public interface ICustomerSource extends IService {

    /**
     * 客户活动来源列表查询
     *
     * @param request 客户活动来源列表查询请求
     * @return 客户活动来源列表查询响应
     */
    CustomerSourceListResponse getCustomerSourceList(CustomerSourceListRequest request);

    /**
     * 保存客户活动来源
     *
     * @param request 客户活动来源请求
     * @return 保存客户活动来源响应
     */
    CustomerSourceResponse addCustomerSource(CustomerSourceRequest request);

    /**
     * 删除客户活动来源通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除客户活动来源响应
     */
    CustomerSourceResponse deleteCustomerSourceById(Integer id);

    /**
     * 修改客户活动来源
     *
     * @param request 修改客户活动来源请求
     * @return 修改客户活动来源响应
     */
    CustomerSourceResponse updateCustomerSource(CustomerSourceRequest request);

    /**
     * 通过ID获取客户活动来源
     *
     * @param id 唯一标识
     * @return 通过ID获取客户活动来源响应
     */
    CustomerSourceResponse getCustomerSourceById(Integer id);

    Integer updateSource(String cityCode, String actSource, String createSource, String crm);

    List<CustomerSourceEntity> queryByConditions(Map<String, Object> map);

}
