<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>排班列表</title>
    <style type="text/css">
        .frm{

        }
        .frm label{
            display: flex;
            align-items: center;
            justify-content: flex-end;
        }
        .frm label .ico{
            width:16px;
            height:16px;
            background-image: url('data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACB0lEQVQ4T6WTMWhUQRCG/9mrtbIwamEnimgRQQUTsMkVoqiolRGtRLB8O3tX6VX3dvfBERDEKmKsVIJoFZuIChowhSKKnYWihZXKdbsj+3grz0sjuMXbnZ3Zf4aZ7xH+c9Hk++FwuLPT6Vwhot0iMp38RLQuIh9CCDf7/f6n9pu/BJxzFwHcIKJlEXksIi8bgcNEdFxETgO4ysy3s8gfAefcDIBnAM4x8/0U4Jw7m/YJ+x6AWWZ+XounT1VVW2KMH5VSc0VRrDePV0VkU1PBT2Y+2sROxxifKKV2FUXxvRZwznkAm5n5crKttfNEdIqZU8nJvxpCGPT7/aeNfQvAD2bWWWBFRO4aY5ZSwGg0mgohbMvVWGtfA1jI/ibBeWbu1gLW2m8xxkOTHU4+7/21GOPceDzuDgaDX+kuTUop9coYszVX8EVEDhpjPrdHVJblrFJqmYiOaa3Xss9au4OI1ph5ey3gvX8kIku5263A6+lsjKn3vNJ0iGhea30iV2CJaEprfaEdWFXVnmQXRfG+fe+9vyMiX5nZ1AINfe8AXGpXUZZlN/l7vd5KOzuAxRDC3tSzNkiJwkWl1IHcfe99DZTWugaqqqrEQJpISlTTOIlyovEhgAci8iLGWNOmlJohoiMAzgA4mSncINBkSVQaAPtEZH9D4hsAb5VSNtHX7seGv7Ht/Jfzb2MR+RGfG8h4AAAAAElFTkSuQmCC');
            background-size: 16px 16px;
            position: relative;
            margin:0 10px;
        }
        .frm label .ico text{
            display: none;
            position: absolute;
            background-color: rgba(0,0,0,.7);
            color:#fff;
            font-size:14px;
            white-space:nowrap;
            left:50%;
            top:-36px;
            transform: translate3d(-50%,0,0);
            padding:5px;
            border-radius: 2px;
        }
        .frm label .ico:hover text{
            display: inline-block;
        }
        .frm label .ico text::after{
            left:50%;
            margin-left:-6px;
            bottom:-6px;
            content: '';
            position: absolute;
            width: 0;
            height: 0;
            border-top: 6px solid rgba(0,0,0,.7);
            border-right: 6px solid transparent;
            border-left: 6px solid transparent;
        }

        * {
            margin: 0;
            padding: 0;
        }

        li {
            list-style: none;
        }

        .clearfix:after,
        .clearfix:before {
            content: '.';
            display: block;
            visibility: hidden;
            font-size: 0;
            line-height: 0;
            width: 0;
            height: 0;
        }

        .clearfix:after {
            clear: both;
        }

        .clearfix {
            zoom: 1;
        }

        .choosemask {
            position: fixed;
            left: 0;
            top: 0;
            background-color: rgba(0, 0, 0, 0.5);
            width: 100%;
            height: 100%;
        }

        .choosemask-wrap {
            width: 280px;
            height: 147px;
            background-color: #fff;
            border: 1px solid #000;
            left: 50%;
            margin-left: -140px;
            top: 200px;
            position: absolute;
        }

        .choosemask-top {
            text-align: right;
            font-size: 20px;
            height: 22px;
            line-height: 22px;
        }

        .choosemask-close {
            cursor: pointer;
            padding: 0 5px;
        }

        .choosemask-bottom {
            width: 217px;
            margin: 0 auto;
        }

        .choosemask-title {
            font-size: 15px;
            height: 18px;
            line-height: 18px;
            text-align: center;
            margin-top: 15px;
        }

        .choosemask-fbs, .choosemask-aj {
            width: 84px;
            height: 23px;
            line-height: 23px;
            text-align: center;
            background-color: #11a0ca;
            color: #fff;
            font-size: 12px;
            cursor: pointer;
            border-radius: 4px;
            -webkit-border-radius: 4px;
            -moz-border-radius: 4px;
        }

        .choosemask-fbs.on, .choosemask-aj.on {
            color: orange;
        }

        .choosemask-fbs {
            float: left;
        }

        .choosemask-aj {
            float: right;
        }

        .choosemask-twobtn {
            margin-top: 36px;
        }
    </style>
</head>
<body>

<!-- 面包屑 begin -->
<div class="container" style="width: 1200px;">
    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>排班列表</li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 begin -->
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/user/" method="get">
                <div class="buttons pull-right" style="margin-left:15px;">
                    <a href="${ctx}/user/addDuty" class="btn blue pull-right" title="新增"><i
                            class="icon-plus"></i></a>
                </div>
            </form>
        </div>
    </div>
    注：更新后的排班将于下次生效，按照当前排序值依次往下执行
    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="100">ID</th>
            <th width="100">用户名</th>
            <th width="100">姓名</th>
            <th width="100">职位</th>
            <th width="100">
                <div style="display: flex">
                    <div>排序</div>
                    <div class="frm"><label class="control-label"><div class="ico"><text>排序值越低，排班班次越前</text></div></label></div></th>
                </div>
            <th width="100">今日值班</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${users}" var="user">
            <tr>

                <td nowrap="nowrap">
                        ${user.entity.id}
                </td>
                <td nowrap="nowrap">
                        ${user.entity.name}
                </td>
                <td nowrap="nowrap">
                        ${user.entity.realName}
                </td>

                <td nowrap="nowrap">
                        ${user.entity.position}
                </td>
                <td nowrap="nowrap">
                        ${user.entity.status}
                </td>
                <td nowrap="nowrap">
                    <c:choose>
                        <c:when test="${!user.entity.enabled}">
                            <span></span>
                        </c:when>
                        <c:when test="${user.entity.enabled}">
                            <span>是</span>
                        </c:when>
                    </c:choose>
                </td>

                <td nowrap="nowrap">

                    <a href="${ctx}/user/addDuty?eid=${user.entity.id}&order=${user.entity.status}" class="icon-edit pointer icon-large" title="编辑"></a>
                    &nbsp; &nbsp;&nbsp;
                    <button class="icon-minus pointer icon-large"
                            onclick="deleteByIds(${user.entity.id}, ${user.entity.enabled})">删除
                    </button>


            </tr>
        </c:forEach>
    </table>
</div>


<script language="javascript" type="text/javascript" src="${ctx}/resources/customize/js/layer.js"></script>

<script type="text/javascript">

    function goEdit(userId) {
        $.ajax({
            url: '${ctx}/user/pbelist/' + userId,
            type: 'GET',
            contentType: 'application/json',
            data: '',
            dataType: 'json',
            cache: false,
            async: false,
            success: function (res) {

            },
            error: function () {

            }
        });
    }

    function deleteByIds(userId, enabled) {
        if (enabled == 1) {
            alert("当前值班人员不可删除！！！")
            return
        }
        var b = confirm("是否删除该员工的排班信息，删除后不可恢复！！！");
        debugger;
        if (b == true) {
            //发送请求
            $.ajax({
                url: '${ctx}/user/deleteDutyById/' + userId,
                type: 'GET',
                contentType: 'application/json',
                data: '',
                dataType: 'json',
                cache: false,
                async: false,
                success: function () {
                    location.href = '${ctx}/user/pblist'
                },
                error: function () {
                    location.href = '${ctx}/user/pblist'
                }
            });
        }
    }

</script>

<div class="modal fade" id="bindModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h5 class="modal-title" id="myModalLabel">绑定微信用户</h5>
            </div>
            <input type="hidden" id="userId" class="m-wrap small"/>
            <input type="hidden" id="wxId" class="m-wrap small"/>
            <div style="margin-top: 10px;" id="tag">
                <div style="float: left;width: 80px">
                    <span class="control-label">微信用户:</span>
                </div>
                <input id="searchName" name="searchName" style="height: 20px;width: 200px;">
            </div>
            <div id="btnGive" class="modal-footer" style="margin-top: 20px;">
                <button type="button" class="btn btn-primary" onclick="bindRelation()">确认</button>
                <button type="button" class="btn btn-primary" onclick="backAdd()">取消</button>
            </div>
        </div>
    </div>
</div>
</body>
</html>
