<%--
  Created by IntelliJ IDEA.
  User: Administrator
  Date: 2018/7/26
  Time: 15:38
  To change this template use File | Settings | File Templates.
--%>
<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>截图功能</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8" />
    <script src="${static_common}/Jcrop-0.9.12/js/jquery.Jcrop.js"></script>
    <link rel="stylesheet" href="${static_common}/Jcrop-0.9.12/css/jquery.Jcrop.css" type="text/css" />
    <script type="text/javascript">

        $(function(){
            $('#cropbox').Jcrop({
                aspectRatio: 1,
                onSelect: updateCoords
            });

        });

        function updateCoords(c)
        {
            $('#x').val(c.x);
            $('#y').val(c.y);
            $('#w').val(c.w);
            $('#h').val(c.h);
        };

        function checkCoords()
        {
            if (parseInt($('#w').val())){
                alert('请先进行图像裁切后进行提交!');
                return false;
            }
        };

        function headportrait() {
            $('#cropbox').Jcrop({
                aspectRatio: 1,
                onSelect: updateCoords
            });
        }
        
        function fullbodypicture() {
            $('#cropbox').Jcrop({
                aspectRatio: 0.75,
                onSelect: updateCoords
            });
        }


        function submitAction(evt) {

            var pictureUrl = $("#pictureUrl").val();
            var x = $("#x").val();
            var y = $("#y").val();
            var w = $("#w").val();
            var h = $("#h").val();
            if ($('#w').val()==''){
                alert('请先进行图像裁切后进行提交!');
                return false;
            }
            $.ajax({
                url: "${ctx}/role/cuttingPictureAction",
                data: {
                    "resourceId":"${resourceId}",
                    "resourceType":"${resourceType}",
                    "bizType":"${bizType}",
                    "imageId":"${imageId}",
                    "pictureUrl": pictureUrl,
                    "x":x,
                    "y":y,
                    "w":w,
                    "h":h,
                },
                type: "GET",
                dataType: "json",
                success: function (data) {
                    if (data.result == '1') {
                        e = window.event || evt;//兼容所有浏览器
                        e.returnValue=false;
                        window.location.href="${ctx}/role/edit/${resourceId}";
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
        }

    </script>
    <style type="text/css">
        #target {
            background-color: #ccc;
            width: 500px;
            height: 330px;
            font-size: 24px;
            display: block;
        }


    </style>

</head>
<body>

<div class="container">
    <div class="row">
        <div class="span12">
            <div class="jc-demo-box">

                <!-- This is the image we're attaching Jcrop to -->
                <img src="${pictureUrl}" id="cropbox" />

                <!-- This is the form that our event handler fills -->
                <form action="crop.php" method="post" onsubmit="return checkCoords();">
                    <input type="hidden" id="x" name="x" />
                    <input type="hidden" id="y" name="y" />
                    <input type="hidden" id="w" name="w" />
                    <input type="hidden" id="h" name="h" />
                    <input type="hidden" id="pictureUrl" name="pictureUrl" value="${pictureUrl}" />
                    <input type="button" onclick="submitAction(event)" value="提交" class="btn btn-large btn-inverse" />
                    <input type="button" value="个人头像比例(1:1)" onclick="headportrait()" class="btn btn-large btn-inverse" />
                    <input type="button" value="全身照比例(3:4)" onclick="fullbodypicture()" class="btn btn-large btn-inverse" />
                </form>
            </div>
        </div>
    </div>
</div>
</body>

</html>
