<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="house365" uri="http://www.house365.com/taglibs" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>

<div class="row-fluid">
    <c:if test="${null != permissions && 0 < fn:length(permissions)}">
        <table id="treeTable" class="table table-advance table-hover hide">
            <tr>
                <td colspan="2">PC端菜单权限</td>
            </tr>
            <c:forEach items="${permissions}" var="permission">
                <tr id="${permission.id}" pId="${permission.parentId}">
                    <td width="40%">${permission.code}</td>
                    <td>
                            ${permission.name}
                    </td>
                </tr>
            </c:forEach>
        </table>
    </c:if>
    <c:if test="${null != wepermissions && 0 < fn:length(wepermissions)}">
        <table id="treeTable1" class="table table-advance table-hover hide">
            <tr>
                <td colspan="2">移动端菜单权限</td>
            </tr>
            <c:forEach items="${wepermissions}" var="permission">
                <tr id="${permission.id}" pId="${permission.parentId}">
                    <td width="40%">${permission.code}</td>
                    <td>
                            ${permission.name}
                    </td>
                </tr>
            </c:forEach>
        </table>
    </c:if>
    <c:if test="${null != funcList && 0 < fn:length(funcList)}">
        <table id="funcTable" class="table table-advance table-hover hide">
            <tr>
                <td colspan="2">功能菜单权限</td>
            </tr>
            <c:forEach items="${funcList}" var="permission">
                <tr id="${permission.id}" pId="${permission.parentId}">
                    <td width="40%">${permission.code}</td>
                    <td>
                            ${permission.name}
                    </td>
                </tr>
            </c:forEach>
        </table>
    </c:if>
</div>

<script type="text/javascript">

    $(document).ready(function () {
        $("#treeTable").treeTable({expandLevel: 3}).show();
        $("#treeTable1").treeTable({expandLevel: 3}).show();
        $("#funcTable").treeTable({expandLevel: 3}).show();
    });

</script>
