<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>客户信息列表</title>
</head>
<body>


<style>
    .pace {
        display: inline-block;
        -webkit-pointer-events: none;
        pointer-events: none;

        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none;

        -webkit-box-sizing: border-box;
        -moz-box-sizing: border-box;
        -ms-box-sizing: border-box;
        -o-box-sizing: border-box;
        box-sizing: border-box;

        -webkit-border-radius: 10px;
        -moz-border-radius: 10px;
        border-radius: 10px;

        -webkit-background-clip: padding-box;
        -moz-background-clip: padding;
        background-clip: padding-box;

        z-index: 2000;
        position: fixed;
        margin: auto;
        top: 12px;
        left: 0;
        right: 0;
        bottom: 0;
        width: 200px;
        height: 50px;
        overflow: hidden;
    }

</style>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active"><span class="divider" style="color:#26a0da;font-weight:bold;">/</span>客户信息列表</li>
        </ul>
    </div>
</div>
<!-- 面包屑 begin -->

<div class="page-container">
    <form id="filterForm" class="form-inline filterForm" action="${ctx}/marketcustomer" method="get">
        <input type="hidden" id="actId" name="search_EQ_activeId" value="${param['search_EQ_activeId']}">
        <input type="hidden" id="type" name="type" value="${type}">

        <div class="row-fluid" style="color: #999999">
            <p><span style="font-size: medium">
            <c:if test="${'' ne act_name || not empty act_name}">${act_name}</c:if>
        </span></p>
            <p>此次共查询到${notassignCount+assignedCount+abandonCount}组客户数据，其中${notassignCount}组数据等待派工</p>
        </div>
        <div class="row-fluid">
            <ul class="nav nav-tabs" style="margin-bottom: 0;position: relative;">
                <li <c:if test="${'' eq type || empty type}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('')">待派（${notassignCount}）</a>
                </li>
                <li <c:if test="${'assigned' eq type}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('assigned')">已派（${assignedCount}）</a>
                </li>
                <li <c:if test="${'notassignandovertime' eq type}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('notassignandovertime')">超时（${notassignandovertimeCount}）</a>
                </li>
                <li <c:if test="${'abandon' eq type}">class="active"</c:if>>
                    <a href="javascript:linkTypeUrl('abandon')">放弃（${abandonCount}）</a>
                </li>
            </ul>
        </div>

        <div class="row-fluid" style="margin-top: 5px;">
            <div class="span10">
                客户电话：<input type="text" id="search_LIKE_phone" name="search_LIKE_phone"
                            value="${param['search_LIKE_phone']}"
                            class="m-wrap small" placeholder="客户电话">
                报名来源：<input type="text" id="search_LIKE_signupSourceName" name="search_LIKE_signupSourceName"
                            value="${param['search_LIKE_signupSourceName']}" class="m-wrap small" placeholder="报名来源">
                报名活动：<input type="text" id="search_LIKE_actSource" name="search_LIKE_actSource"
                            value="${param['search_LIKE_actSource']}" class="m-wrap small" placeholder="报名活动">
                置业顾问：<input type="text" id="search_LIKE_managerName" name="search_LIKE_managerName"
                            value="${param['search_LIKE_managerName']}"
                            class="m-wrap small" placeholder="置业顾问">
                <c:if test="${'assigned' eq type}">
                    状态： <select style="width: 6rem" name="search_EQ_isBack" id="search_EQ_isBack">
                    <option value="" selected="selected">全部</option>
                    <option value="1" <c:if test="${'1' eq param['search_EQ_isBack']}">selected="selected"</c:if>>已回访
                    </option>
                    <option value="0" <c:if test="${'0' eq param['search_EQ_isBack']}">selected="selected"</c:if>>未回访
                    </option>
                </select>
                </c:if>
                <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
            </div>
            <div class="span2">
                <c:choose>
                    <c:when test="${'abandon' ne type}">
                        <c:if test="${page.records>0}">
                            <div class="bottomBtnR" onclick="assignManager()">批量派工</div>
                            <div class="bottomBtnR" onclick="allAssignManager()">派工所有</div>
                        </c:if>
                    </c:when>
                </c:choose>
            </div>
        </div>

    </form>

    <table class="table table-striped table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center">
                <input id="memberCheckAll" type="checkbox" onclick="checkAll(this)"/>
            </th>
            <th width="100">id</th>
            <th width="100">姓名</th>
            <th width="100">手机号</th>
            <th width="100">报名项目</th>
            <th width="100">最近报名来源</th>
            <th width="100">最近报名活动</th>
            <th width="100">报名时间</th>
            <th width="100">
                <c:choose>
                    <c:when test="${'assigned' eq type}">
                        <span class="inline">派工时间</span>
                    </c:when>
                    <c:otherwise>
                        上次派工时间
                    </c:otherwise>
                </c:choose>
            </th>
            <th width="100">
                <c:choose>
                    <c:when test="${'assigned' eq type}">
                        <span class="inline">置业顾问</span>
                    </c:when>
                    <c:otherwise>
                        原置业顾问
                    </c:otherwise>
                </c:choose>
            </th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${marketCustomers}" var="marketCustomer">
            <c:choose>
                <c:when test="${marketCustomer.isabandonother gt 0 and 'notassignandovertime' ne type}">
                    <tr style="color:red;">
                </c:when>
                <c:otherwise>
                    <tr>
                </c:otherwise>
            </c:choose>
            <td nowrap="nowrap" style="text-align:center">
                <input type="checkbox" id="ck_${marketCustomer.id}" name="memberCheck" value="${marketCustomer.id}"
                       onclick="checkMember(this)"/>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne marketCustomer.id && '' ne marketCustomer.id}">
                    <c:out value="${marketCustomer.id}"/>
                </c:if>
                <c:if test="${null eq marketCustomer.id || '' eq marketCustomer.id}">
                    &nbsp;-
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne marketCustomer.name && '' ne marketCustomer.name}">
                    <c:out value="${marketCustomer.name}"/>
                </c:if>
                <c:if test="${null eq marketCustomer.name || '' eq marketCustomer.name}">
                    &nbsp;-
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne marketCustomer.phone && '' ne marketCustomer.phone}">
                    <c:out value="${marketCustomer.phone}"/>
                </c:if>
                <c:if test="${null eq marketCustomer.phone || '' eq marketCustomer.phone}">
                    &nbsp;-
                </c:if>
            </td>
            <td nowrap="nowrap" width="100">
                <c:if test="${null ne marketCustomer.signupHouseName && '' ne marketCustomer.signupHouseName}">
                    <c:out value="${marketCustomer.signupHouseName}"/>
                </c:if>
                <c:if test="${null eq marketCustomer.signupHouseName || '' eq marketCustomer.signupHouseName}">
                    &nbsp;-
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne marketCustomer.signupSourceName && '' ne marketCustomer.signupSourceName}">
                    <c:out value="${marketCustomer.signupSourceName}"/>
                </c:if>
                <c:if test="${null eq marketCustomer.signupSourceName || '' eq marketCustomer.signupSourceName}">
                    &nbsp;-
                </c:if>
            </td>
            <td nowrap="nowrap" width="300">
                <c:if test="${null ne marketCustomer.actSource && '' ne marketCustomer.actSource}">
                    <c:out value="${marketCustomer.actSource}"/>
                </c:if>
                <c:if test="${null eq marketCustomer.actSource || '' eq marketCustomer.actSource}">
                    &nbsp;-
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne marketCustomer.signupTime && '' ne marketCustomer.signupTime}">
                    <c:out value="${marketCustomer.signupTime}"/>
                </c:if>
                <c:if test="${null eq marketCustomer.signupTime || '' eq marketCustomer.signupTime}">
                    &nbsp;-
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne marketCustomer.bindTime && '' ne marketCustomer.bindTime}">
                    <f:formatDate value='${marketCustomer.bindTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                </c:if>
                <c:if test="${null eq marketCustomer.bindTime || '' eq marketCustomer.bindTime}">
                    &nbsp;-
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:choose>
                    <c:when test="${'assigned' eq type}">
                        <c:if test="${null ne marketCustomer.managerName && '' ne marketCustomer.managerName}">
                            <c:out value="${marketCustomer.managerName}"/>
                        </c:if>
                        <c:if test="${null eq marketCustomer.managerName || '' eq marketCustomer.managerName}">
                            &nbsp;-
                        </c:if>
                    </c:when>
                    <c:otherwise>
                        <c:if test="${null ne marketCustomer.lastManager && '' ne marketCustomer.lastManager}">
                            <c:out value="${marketCustomer.lastManager}"/>
                        </c:if>
                        <c:if test="${null eq marketCustomer.lastManager || '' eq marketCustomer.lastManager}">
                            &nbsp;-
                        </c:if>
                    </c:otherwise>
                </c:choose>

            </td>

            <td nowrap="nowrap">
                <c:choose>
                    <c:when test="${'assigned' eq type}">
                        <div class="bottomBtnR" onclick="customerInfo(${marketCustomer.id})">查看</div>
                        <div class="bottomBtnR" onclick="getCRM(${marketCustomer.id})">CRM视图</div>
                        <div class="bottomBtnR" onclick="assignManagerSingle(${marketCustomer.id})">
                            <c:choose>
                                <c:when test="${'assigned' eq type}">
                                    <span class="inline">改派</span>
                                </c:when>
                                <c:otherwise>
                                    派工
                                </c:otherwise>
                            </c:choose>
                        </div>
                    </c:when>
                    <c:when test="${'abandon' eq type}">
                        <div class="bottomBtnR" onclick="abandonMsg(${marketCustomer.id})">
                            <span class="inline">放弃原因</span>
                        </div>
                    </c:when>
                    <c:otherwise>
                        <div class="bottomBtnR" onclick="getCRM(${marketCustomer.id})">CRM视图</div>
                        <div class="bottomBtnR" onclick="assignManagerSingle(${marketCustomer.id})">派工</div>
                    </c:otherwise>
                </c:choose>

            </td>
            </tr>
        </c:forEach>
    </table>

    <c:choose>
        <c:when test="${'abandon' ne type}">
            <c:if test="${page.records>0}">
                <div class="row-fluid">
                    <div class="bottomBtnR" onclick="assignManager()">批量派工</div>
                    <div class="bottomBtnR" onclick="allAssignManager()">派工所有</div>
                </div>
            </c:if>
        </c:when>
    </c:choose>

    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script type="text/javascript">

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    });

    function linkTypeUrl(_type) {
        $("#type").val(_type);
        $('#search_LIKE_phone').val('');
        $('#search_LIKE_signupSourceName').val('');
        $('#search_LIKE_managerName').val('');

        $('#filterForm').submit();
    }

    function assignManagerSingle(customerId) {
        $("#ck_" + customerId).prop("checked", true);
        openAssignWindow(1, customerId);
    }

    function allAssignManager() {
        openAllAssignWindow("${page.records}");
    }

    function abandonMsg(id) {
        $.ajax({
            url: '/house365-hgs-web/marketcustomer/abandonMsg',
            data: {
                "customerId": id
            },
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    House365Util.createModal("放弃原因", data.msg, function () {
                    });
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });

    }

    function assignManager() {
        var customerIds = "",
            customerCont = 0;
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
                customerCont += 1;
            }
        }

        if (customerIds == '') {
            alert("请至少选择一个客户!");
            return false;
        }
        openAssignWindow(customerCont, customerIds);
    }

    function openAllAssignWindow(customerCont) {
        House365Util.createRemoteModal("客户派工", "/house365-hgs-web/customer/assignManager?multyassign=1&customerCount=" + customerCont, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            $.ajax({
                url: '/house365-hgs-web/customer/assign',
                data: {
                    "userIds": userIds,
                    "actid": "${param['search_EQ_activeId']}",
                    "customerType": $("#type").val(),
                    "type": "all"
                },
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        alert(data.msg);
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
        $(".modal").css("width", "560px");
    }

    function openAssignWindow(customerCont, customerIds) {
        House365Util.createRemoteModal("客户派工", "/house365-hgs-web/customer/assignManager?multyassign=1&customerCount=" + customerCont, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            if (customerIds == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            $.ajax({
                url: '/house365-hgs-web/customer/assign',
                data: {
                    "userIds": userIds,
                    "customerIds": customerIds,
                    "type": "market"
                },
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        alert(data.msg);
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
        $(".modal").css("width", "560px");
    }

    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/marketcustomer/getCRMURL',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

    function customerInfo(id) {

        $.ajax({
            url: '/house365-hgs-web/marketcustomer/judgeCustomer/' + id,
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    var customerId = data.data.customerId;
                    window.open("/house365-hgs-web/customer/customerInfo?action=edit&customerId=" + customerId, "_blank");
                } else if(data.status == 101){
                    var customerId = data.data.customerId;
                    window.open("/house365-hgs-web/customer/seaCustomerInfo?action=edit&customerId=" + customerId, "_blank");
                } else {
                    alert(data.errorMessage);
                }
            }
        });

    }



</script>
<script>
    $(function(){
        setTimeout(function () {
            $(".pace").hide()
        },1000)
    })

</script>
</body>
</html>
