<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<style>
    .tag-item {
        height: 1rem;
        padding: 0 10px;
        border-radius: 3px;
        display: inline-block;
        line-height: 0.9rem;
        font-size: 0.6rem;
        border: 1px solid;
        box-sizing: border-box;
    }

    .tag-item.can_close:after {
        content: 'x';
        position: relative;
        left: 0.3rem;
        transform: scale(1.2, 0.9);
        display: inline-block;
    }

    .result-tag {
        min-height: 2rem;
        display: flex;
        align-items: center;
        flex-wrap: wrap;
    }

    .center {
        /* margin: 0 auto; */
        padding: 5px;
    }

    .all-tag .tag-item, .result-tag .tag-item {
        margin: 3px 4px;
    }

    .all-tag {
        min-height: 7rem;
    }

    .tag-label {
        color: #999;
        line-height: 2rem;
        margin-left: 15px;
    }

    .nothing {
        text-align: center;
        color: #888;
    }

    /* tag */

    .gray {
        color: #999;
        border-color: #999;
    }

    .red {
        color: #d9534f;
        border-color: #d9534f;
    }

    .orange {
        color: #f0ad4e;
        border-color: #f0ad4e;
    }

    .green {
        color: #5cb85c;
        border-color: #5cb85c;
    }

    .blue {
        color: #5bc0de;
        border-color: #5bc0de;
    }

    .darkblue {
        color: #0275d8;
        border-color: #0275d8;
    }

    .zi {
        color: #663399;
        border-color: #663399;
    }

    /* back */

    .gray.active {
        background-color: #999;
        border-color: transparent;
        color: white;
    }

    .red.active {
        background-color: #d9534f;
        border-color: transparent;
        color: white;
    }

    .orange.active {
        background-color: #f0ad4e;
        border-color: transparent;
        color: white;
    }

    .green.active {
        background-color: #5cb85c;
        border-color: transparent;
        color: white;
    }

    .blue.active {
        background-color: #5bc0de;
        border-color: transparent;
        color: white;
    }

    .darkblue.active {
        background-color: #0275d8;
        border-color: transparent;
        color: white;
    }

    .zi.active {
        background-color: #663399;
        border-color: transparent;
        color: white;
    }
    .btn.blues{
        margin-left: 400px;
    }
    .tag-item.active:before{
        content:'√';
        color: white;
    }
    .tag-item.active{
        vertical-align: top;
    }
</style>
<house365:flushMessage/>
<div class="row${fluid}">
    <div class="span12">
        <div class="form-horizontal house365Page">
            <div class="house365Border">
                <!-- 片段头 begin -->
                <div class="sectionTitle">
                    <h5>编辑</h5>
                </div>
                <input id="colorId" name="colorId" type="hidden" value=""/>
                <div class="row-fluid">
                            <div class="span6 control-group">
                                <label class="control-label">标签名称<font style="color: red;">*</font>:</label>
                                <div class="controls">
                                    <input type="text" id="labelName"
                                           name="labelName" class="required" maxlength="4" value="${labelName}"/>
                                </div>
                            </div>
                </div>
                <div class="row-fluid">
                    <div class="span6 control-group">
                        <label class="control-label">标签颜色<font style="color: red;">*</font>:</label>
                        <div class="controls all-tag bor-t">
                            <span id="c1" class="tag-item gray" style="background:#999" data-index="1">1</span>
                            <span id="c2" class="tag-item red" style="background:#d9534f" data-index="2">2</span>
                            <span id="c3" class="tag-item orange" style="background:#f0ad4e" data-index="3">3</span>
                            <span id="c4" class="tag-item green" style="background:#5cb85c" data-index="4">4</span>
                            <span id="c5" class="tag-item blue" style="background:#5bc0de" data-index="5">5</span>
                            <span id="c6" class="tag-item darkblue" style="background:#0275d8" data-index="6">6</span>
                            <span id="c7" class="tag-item zi" style="background:#663399" data-index="7">7</span>
                        </div>
                    </div>
                </div>

                <div class="row-fluid">
                    <a href="javascript:window.opener=null;window.open('','_self');window.close();" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;取消</a>
                    <a class="btn blues" onclick="updateLabel(${id}, ${colorId});">保存</a>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(function () {
        //点击标签
        $('.all-tag').on('click', '.tag-item',function() {
            $('.all-tag .tag-item').removeClass('active')
            $(this).addClass('active');
        })
        var colorId = "${colorId}";
        var id = "${id}";
        if(colorId == 1){
            $("#c1").removeClass("tag-item gray");
            $("#c1").addClass("tag-item gray active");
        }
        if(colorId == 2){
            $("#c2").removeClass("tag-item red");
            $("#c2").addClass("tag-item red active");
        }
        if(colorId == 3){
            $("#c3").removeClass("tag-item orange");
            $("#c3").addClass("tag-item orange active");
        }
        if(colorId == 4){
            $("#c4").removeClass("tag-item green");
            $("#c4").addClass("tag-item green active");
        }
        if(colorId == 5){
            $("#c5").removeClass("tag-item blue");
            $("#c5").addClass("tag-item blue active");
        }
        if(colorId == 6){
            $("#c6").removeClass("tag-item darkblue");
            $("#c6").addClass("tag-item darkblue active");
        }
        if(colorId == 7){
            $("#c7").removeClass("tag-item zi");
            $("#c7").addClass("tag-item zi active");
        }


    });

    function updateLabel(id, colorId) {
        var labelName = $("#labelName").val();
        if(labelName ==''){
            alert("标签名称不能为空");
            return false;
        }
        labelName = labelName.replace(/\s*/g,"");
        if(labelName ==''){
            alert("标签名称不能为空");
            return false;
        }
        if(labelName.length>4){
            alert("标签名称最多4个字");
            return false;
        }

        colorId = document.getElementsByClassName("active")[0].innerText;
        $("#colorId").val(colorId);
//        $("#labName").val(labelName);
        $.ajax({
            url: '${ctx}/labelmanager/updateLabel',
            contentType: "application/x-www-form-urlencoded:charset=UTF-8",
            data: {'id': id,'labelName': labelName, "colorId": colorId},
            type: "GET",
            success: function (data) {
                if(data == "success"){
                    alert("修改成功");
                    window.location.href ="${ctx}/labelmanager";
                }else{
                    alert("修改失败");
                    return false;
                }
            }
        });
    }
</script>

</body>
</html>
