/**
 * Description: UserSourceStatistics控制器
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-25 上午 09:50:45
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-25   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.house365.beans.entity.UserSourceStatisticsEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.UserSourceStatisticsVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.UserSourceStatisticsListRequest;
import com.house365.ws.beans.request.UserSourceStatisticsRequest;
import com.house365.ws.beans.response.UserSourceStatisticsListResponse;
import com.house365.ws.beans.response.UserSourceStatisticsResponse;
import com.house365.ws.interfaces.server.IUserSourceStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Map;

/**
 * UserSourceStatistics控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-25
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/usersourcestatistics")
public class UserSourceStatisticsController extends BaseController {

    /**
     * 自动注入UserSourceStatisticsWS实现
     */
    @Autowired
    private IUserSourceStatistics userSourceStatistics;

    /**
     * 去新增UserSourceStatistics
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增UserSourceStatistics
     *
     * @param vo     UserSourceStatistics页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createUserSourceStatistics(@Valid UserSourceStatisticsVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model) {
        UserSourceStatisticsEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                UserSourceStatisticsRequest request = new UserSourceStatisticsRequest();
                request.setEntity(entity);
                UserSourceStatisticsResponse response = userSourceStatistics
                        .addUserSourceStatistics(request);
                Integer id = response.getEntity().getId();
                return "redirect:/usersourcestatistics/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除UserSourceStatistics
     *
     * @param id UserSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    userSourceStatistics.deleteUserSourceStatisticsById(Integer.valueOf(ids[i]));
                }
            } else {
                userSourceStatistics.deleteUserSourceStatisticsById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看UserSourceStatistics
     *
     * @param id UserSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        UserSourceStatisticsResponse response = userSourceStatistics
                .getUserSourceStatisticsById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改UserSourceStatistics
     *
     * @param id UserSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        UserSourceStatisticsResponse response = userSourceStatistics
                .getUserSourceStatisticsById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改UserSourceStatistics
     *
     * @param vo     UserSourceStatistics页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateUserSourceStatistics(@Valid UserSourceStatisticsVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model) {
        UserSourceStatisticsEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                UserSourceStatisticsRequest request = new UserSourceStatisticsRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                UserSourceStatisticsResponse rersponse = userSourceStatistics
                        .updateUserSourceStatistics(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/usersourcestatistics/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询UserSourceStatistics
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
        Page page = new Page();
        if (null != number) {
            page.setCurrentPage(number);
        }
        UserSourceStatisticsListRequest listRequest = new UserSourceStatisticsListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        UserSourceStatisticsListResponse response = userSourceStatistics.getUserSourceStatisticsList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("userSourceStatisticss", response.getObjectList());
        model.addAttribute("searchParams", Servlets
                .encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }
}
