/**
 * Description: StatusSourceStatistics控制器
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-11-02 下午 17:54:57
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-11-02   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.web.controller;

import com.house365.beans.entity.StatusSourceStatisticsEntity;
import com.house365.beans.system.Page;
import com.house365.beans.vo.StatusSourceStatisticsVo;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.StringUtils;
import com.house365.ws.beans.request.StatusSourceStatisticsListRequest;
import com.house365.ws.beans.request.StatusSourceStatisticsRequest;
import com.house365.ws.beans.response.StatusSourceStatisticsListResponse;
import com.house365.ws.beans.response.StatusSourceStatisticsResponse;
import com.house365.ws.interfaces.server.IStatusSourceStatistics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Map;

/**
 * StatusSourceStatistics控制器<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-11-02
 * @see
 * @since 1.0
 */
@Controller
@RequestMapping("/statussourcestatistics")
public class StatusSourceStatisticsController extends BaseController {

    /**
     * 自动注入StatusSourceStatisticsWS实现
     */
    @Autowired
    private IStatusSourceStatistics statusSourceStatistics;

    /**
     * 去新增StatusSourceStatistics
     *
     * @return 结果视图
     */
    @RequestMapping(value = "", params = "action=create")
    public String createForm(Model model) {
        model.addAttribute("action", "create");
        return getAutoUrl("form");
    }

    /**
     * 新增StatusSourceStatistics
     *
     * @param vo StatusSourceStatistics页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "", method = {RequestMethod.POST})
    public String createStatusSourceStatistics(@Valid StatusSourceStatisticsVo vo, BindingResult result, RedirectAttributes redirectAttributes, Model model) {
        StatusSourceStatisticsEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                StatusSourceStatisticsRequest request = new StatusSourceStatisticsRequest();
                request.setEntity(entity);
                StatusSourceStatisticsResponse response = statusSourceStatistics
                        .addStatusSourceStatistics(request);
                Integer id = response.getEntity().getId();
                return "redirect:/statussourcestatistics/" + id;
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "create");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 删除StatusSourceStatistics
     *
     * @param id StatusSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.DELETE})
    @ResponseStatus(HttpStatus.OK)
    public void delete(@PathVariable String id) {
        if (!StringUtils.isEmpty(id)) {
            if (id.contains(",")) {
                String[] ids = id.split(",");
                for (int i = 0; i < ids.length; i++) {
                    statusSourceStatistics.deleteStatusSourceStatisticsById(Integer.valueOf(ids[i]));
                }
            } else {
                statusSourceStatistics.deleteStatusSourceStatisticsById(Integer.valueOf(id));
            }
        }
    }

    /**
     * 去查看StatusSourceStatistics
     *
     * @param id    StatusSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET})
    public String showForm(@PathVariable(value = "id") Integer id, Model model) {
        StatusSourceStatisticsResponse response = statusSourceStatistics
                .getStatusSourceStatisticsById(id);
        model.addAttribute("entity", response.getEntity());
        return getAutoUrl("form");
    }

    /**
     * 去修改StatusSourceStatistics
     *
     * @param id StatusSourceStatistics页面表单对象唯一标识
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.GET}, params = "action=edit")
    public String updateForm(@PathVariable(value = "id") Integer id, Model model) {
        StatusSourceStatisticsResponse response = statusSourceStatistics
                .getStatusSourceStatisticsById(id);
        model.addAttribute("entity", response.getEntity());
        model.addAttribute("action", "edit");
        return getAutoUrl("form");
    }

    /**
     * 修改StatusSourceStatistics
     *
     * @param vo StatusSourceStatistics页面表单对象
     * @param result 表单验证数据
     * @return 结果视图
     */
    @RequestMapping(value = "/{id}", method = {RequestMethod.POST})
    public String updateStatusSourceStatistics(@Valid StatusSourceStatisticsVo vo, BindingResult result, @PathVariable Integer id, RedirectAttributes redirectAttributes, Model model) {
        StatusSourceStatisticsEntity entity = vo.getEntity();
        model.addAttribute("entity", entity);
        // subValidation(result, entity);
        // 表单验证无误,进行提交
        if (result.hasErrors()) {
            model.addAttribute("action", "create");
            addErrorMessage(model, result.getFieldError().getDefaultMessage());
            return getAutoUrl("form");
        } else {
            try {
                StatusSourceStatisticsRequest request = new StatusSourceStatisticsRequest();
                request.setEntity(entity);
                @SuppressWarnings("unused")
                StatusSourceStatisticsResponse rersponse = statusSourceStatistics
                        .updateStatusSourceStatistics(request);
                redirectAttributes.addAttribute("message", "更新成功");
                return "redirect:/statussourcestatistics/" + entity.getId();
            } catch (Exception ex) {
                addErrorMessage(model, ex.getMessage());
                model.addAttribute("action", "edit");
                return getAutoUrl("form");
            }
        }
    }

    /**
     * 查询StatusSourceStatistics
     *
     * @param request 请求对象
     * @return 结果视图
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Model model, HttpServletRequest request) {
        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(
                request, "search_");
        Page page = new Page();
        if (null != number) {
            page.setCurrentPage(number);
        }
        StatusSourceStatisticsListRequest listRequest = new StatusSourceStatisticsListRequest();
        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);
        StatusSourceStatisticsListResponse response = statusSourceStatistics.getStatusSourceStatisticsList(listRequest);
        model.addAttribute("page", response.getPaging());
        model.addAttribute("statusSourceStatisticss", response.getObjectList());
        model.addAttribute("searchParams", Servlets.encodeParameterStringWithPrefix(searchParams, "search_"));
        return getAutoUrl();
    }
}
