package com.house365.web.controller;

import com.google.common.base.Strings;
import com.house365.beans.entity.CustomerCallbackRecordEntity;
import com.house365.beans.entity.DepartmentEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.system.Page;
import com.house365.web.system.controller.BaseController;
import com.house365.web.util.MobileUtil;
import com.house365.web.util.SessionConstants;
import com.house365.ws.beans.request.CustomerCallbackRecordListRequest;
import com.house365.ws.beans.response.CustomerCallbackRecordListResponse;
import com.house365.ws.beans.response.DepartmentResponse;
import com.house365.ws.interfaces.server.ICustomerCallbackRecord;
import com.house365.ws.interfaces.server.IDepartment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 回访录音controller
 *
 * @author Administrator
 * @date 2018/6/25
 */
@Controller
@RequestMapping("/callbackrecord")
public class CallbackRecordController extends BaseController {

    @Autowired
    private ICustomerCallbackRecord customerCallbackRecord;

    @Autowired
    private IDepartment department;

    @RequestMapping(value = "", method = RequestMethod.GET)
    public String list(Integer number, Integer pageSize, Model model, HttpServletRequest request) {

        // 获取查询条件
        Map<String, Object> searchParams = Servlets.getParametersStartingWith(request, "search_");
        Page page = new Page(pageSize == null ? 50 : pageSize);
        if (null != number) {
            page.setCurrentPage(number);
        }

        UserEntity userEntity = (UserEntity) request.getSession().getAttribute(SessionConstants.THREAD_USER_KEY);

        DepartmentEntity departmentEntity = (DepartmentEntity) request.getSession().getAttribute(
                SessionConstants.SESSION_CURRNET_DEPT_KEY);
        String cityId = departmentEntity.getCityID();
        DepartmentResponse departmentResponse = department.getDepartmentById(Integer.valueOf(cityId));
        String cityCode = departmentResponse.getEntity().getDescripition();
        String managerId = request.getParameter("managerId");

        //自己和子部门数据
        searchParams.put("EQ_userId", userEntity.getId());
        searchParams.put("EQ_cityCode", cityCode);

        if (Strings.isNullOrEmpty((String) searchParams.get("LIKE_keyword"))) {
            searchParams.remove("EQ_recordedStatus");
        } else {
            searchParams.put("LIKE_keyword", searchParams.get("LIKE_keyword"));
        }

        if (Strings.isNullOrEmpty((String) searchParams.get("GTE_createTimeStart"))) {
            searchParams.remove("GTE_createTimeStart");
        } else {
            String createTimeStart = (String) searchParams.get("GTE_createTimeStart") + " 00:00:00";
            searchParams.put("GTE_createTimeStart", createTimeStart);
        }

        if (Strings.isNullOrEmpty((String) searchParams.get("LTE_createTimeEnd"))) {
            searchParams.remove("LTE_createTimeEnd");
        } else {
            String createTimeEnd = searchParams.get("LTE_createTimeEnd") + " 23:59:59";
            searchParams.put("LTE_createTimeEnd", createTimeEnd);
        }

        if (!Strings.isNullOrEmpty(managerId) && managerId.trim().length() != 0) {
            searchParams.put("EQ_managerId", managerId);
        }
        CustomerCallbackRecordListRequest listRequest = new CustomerCallbackRecordListRequest();

        listRequest.setOrderColumn("create_time");
        listRequest.setOrderMode("desc");

        listRequest.setPaging(page);
        listRequest.setSearchParams(searchParams);

        CustomerCallbackRecordListResponse response = customerCallbackRecord.getCustomerCallbackRecordList(listRequest);

        List<CustomerCallbackRecordEntity> entities = response.getObjectList();
        /**
         * 用户无权查看完整手机号
         */
        if(userEntity.getShowMobile() == null || userEntity.getShowMobile() != 1) {
            entities = entities.stream().map(i-> {
                i.setPhone(MobileUtil.hidePhone(i.getPhone()));
                return i;
            }).collect(Collectors.toList());
        }
        model.addAttribute("page", entities);
        model.addAttribute("callbackrecords", response.getObjectList());
        model.addAttribute("searchParams", Servlets.encodeParameterStringWithPrefix(searchParams, "search_"));

        return getAutoUrl();
    }

}
