/**
 * Description: 客户信息页面表单对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-12-05 下午 19:21:01
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.house365.beans.entity.MarketCustomerEntity;

/**
 * 客户信息页面表单对象<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
public class MarketCustomerVo{
	/**
	 * 客户信息实体
	 */
    @NotNull
    @Valid
	private MarketCustomerEntity entity;
	

	/**
	 * 设置客户信息实体
	 * @param entity 客户信息实体
	 */
	public void setEntity(MarketCustomerEntity entity) {
		this.entity = entity;
	}

	/**
	 * 获取客户信息实体
	 * @return 客户信息实体
	 */
	public MarketCustomerEntity getEntity() {
		return this.entity;
	}
}