/**
 * Description: 驻场日报页面表单对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 上午 10:14:22
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.vo;

import java.io.Serializable;

/**
 * 驻场日报页面表单对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
public class LocalReportFormVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 渠道ID
     */
    private Integer channelId;

    private String channelName;

    private String channelType;

    /**
     * 部门ID
     */
    private Integer departId;
    private String departName;

    /**
     * 职员ID
     */
    private Integer userId;

    /**
     * 职员名
     */
    private String name;

    /**
     * 报备
     */
    private Integer record;

    /**
     * 到访
     */
    private Integer visit;

    /**
     * 认筹
     */
    private Integer buyorder;
    /**
     * 认购
     */
    private Integer buy;

    /**
     * 业绩
     */
    private Integer score;

    private String reportDate;

    private String projectname;

    private Integer projectId;

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getProjectname() {
        return projectname;
    }

    public void setProjectname(String projectname) {
        this.projectname = projectname;
    }

    public Integer getProjectId() {
        return projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public Integer getChannelId() {
        return channelId;
    }

    public void setChannelId(Integer channelId) {
        this.channelId = channelId;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public Integer getDepartId() {
        return departId;
    }

    public void setDepartId(Integer departId) {
        this.departId = departId;
    }

    public String getDepartName() {
        return departName;
    }

    public void setDepartName(String departName) {
        this.departName = departName;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getRecord() {
        return record;
    }

    public void setRecord(Integer record) {
        this.record = record;
    }

    public Integer getVisit() {
        return visit;
    }

    public void setVisit(Integer visit) {
        this.visit = visit;
    }

    public Integer getBuy() {
        return buy;
    }

    public void setBuy(Integer buy) {
        this.buy = buy;
    }

    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public Integer getBuyorder() {
        return buyorder;
    }

    public void setBuyorder(Integer buyorder) {
        this.buyorder = buyorder;
    }

    public String getReportDate() {
        return reportDate;
    }

    public void setReportDate(String reportDate) {
        this.reportDate = reportDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;

        LocalReportFormVo that = (LocalReportFormVo) o;

        //not 365 channel just compare channel id
        if ("2".equalsIgnoreCase(((LocalReportFormVo) o).getChannelType()) && channelId.equals(that.channelId)) {
            return true;
        }

        if (projectId != null ? !projectId.equals(that.projectId) : that.projectId != null)
            return false;
        if (channelId != null ? !channelId.equals(that.channelId) : that.channelId != null)
            return false;
        if (departId != null ? !departId.equals(that.departId) : that.departId != null)
            return false;
        if (userId != null ? !userId.equals(that.userId) : that.userId != null)
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = channelId != null ? channelId.hashCode() : 0;
        result = 31 * result + (channelName != null ? channelName.hashCode() : 0);
        result = 31 * result + (departId != null ? departId.hashCode() : 0);
        result = 31 * result + (departName != null ? departName.hashCode() : 0);
        result = 31 * result + (userId != null ? userId.hashCode() : 0);
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (record != null ? record.hashCode() : 0);
        result = 31 * result + (visit != null ? visit.hashCode() : 0);
        result = 31 * result + (buy != null ? buy.hashCode() : 0);
        result = 31 * result + (score != null ? score.hashCode() : 0);
        result = 31 * result + (buyorder != null ? buyorder.hashCode() : 0);
        result = 31 * result + (reportDate != null ? reportDate.hashCode() : 0);
        return result;
    }
}
