/**
 * Description: 账户数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:22
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 账户数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @since 1.0
 */
public class UserEntity extends DomainObject implements Cloneable {

    private static final long serialVersionUID = 1L;

    private String limitLogin;

    private String managerName;

    /**
     * 用户名
     */
    @Length(max = 64, message = "长度需要大于0且小于64")
    private String name;

    @Length(max = 64, message = "长度需要大于0且小于64")
    private String realName;

    /**
     * 密码
     */
    @Length(max = 255, message = "长度需要大于0且小于255")
    private String password;

    /**
     * 微信号
     */
    @Length(max = 64, message = "长度需要大于0且小于64")
    private String weiXinId;

    /**
     * 成员头像的mediaid
     */
    @Length(max = 64, message = "长度需要大于0且小于64")
    private String mediaId;

    /**
     * 手机号
     */
    @Length(max = 11, message = "长度需要大于0且小于11")
    private String mobile;
    /**
     * 短号
     */
    @Length(max = 11, message = "长度需要大于0且小于11")
    private String cornet;


    /**
     * 部门编号
     */
    private Integer deptId;

    /**
     * 部门名称
     */
    private String deptName;

    private String setKefu;

    private String kefuAccid;


    private String resourceId;//资源ID

    private String remotePath;//头像

    private String personHotline;    //分机号

    private String deptUrlPath;

    //1:安家顾问,3:新房房博士6二手房房博士 10 租房房博士 7 客服 20 平台人员
    private String identityType;
    private String accId;//云信id
    private String token;//云信token
    private String imshow;//手否展示IM窗口聊天

    private int promoteId;

    /**
     * 职位
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String position;

    /**
     * 1男 2女
     */
    @Length(max = 1, message = "长度需要大于0且小于1")
    private String gender;

    /**
     * 邮箱
     */
    @Email
    @Length(max = 64, message = "长度需要大于0且小于64")
    private String email;

    /**
     * 扩展属性
     */
    @Length(max = 400, message = "长度需要大于0且小于400")
    private String extattr;

    /**
     * 关注状态: 1=已关注，2=已禁用，4=未关注
     */
    private Integer status;

    /**
     * 1启用 0冻结
     */
    private Boolean enabled;

    /**
     * 创建人用户ID
     */
    private Integer createUserid;

    //取消客户转移限制(即所有人都可以向该用户转移客户) 1 yes 0 no
    private Integer isFreeMan;

    private Integer defaultVisit;

    /**
     * 创建人用户名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String createUsername;

    /**
     * 创建时间
     */
    private Date createTime;

    private Date lastLoginTime;

    private Date preLoginTime;

    /**
     * 创建人电脑IP
     */
    @Length(max = 30, message = "长度需要大于0且小于30")
    private String createIp;

    /**
     * 最后一次修改人用户ID
     */
    private Integer updateUserid;

    /**
     * 最后一次修改人用户名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String updateUsername;

    /**
     * 最后一次修改时间
     */
    private Date updateTime;

    /**
     * 最后一次修改人电脑IP
     */
    @Length(max = 30, message = "长度需要大于0且小于30")
    private String updateIp;

    private boolean projectAuthorized;

    private Integer projectId;

    private String hotlinephone;

    //业务专长
    private String goodat;
    //个人介绍
    private String description;
    //头像
    private String headImgURL;
    //全身像
    private String fullImgURL;
    //评价分
    private BigDecimal score;
    //评价次数
    private Integer evaluateCount;
    //所属城市
    private String city;
    //城市名称
    private String cityName;
    //带看次数
    private Integer seeCount;

    private String wxNumber;
    private String wxCodeImgUrl;
    private Integer onlineStatus;
    private Integer isOpen;

    /**
     * 用户是否可以看到完整的客户手机号码
     * 1，可以
     */
    private Integer showMobile;

    public void setShowMobile(Integer showMobile) {
        this.showMobile = showMobile;
    }

    public Integer getShowMobile() {
        return showMobile;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public String getImshow() {
        return imshow;
    }

    public void setImshow(String imshow) {
        this.imshow = imshow;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getIdentityType() {
        return identityType;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public String getAccId() {
        return accId;
    }

    public void setAccId(String accId) {
        this.accId = accId;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public Integer getDefaultVisit() {
        return defaultVisit;
    }

    public void setDefaultVisit(Integer defaultVisit) {
        this.defaultVisit = defaultVisit;
    }

    public Integer getSeeCount() {
        return seeCount;
    }

    public void setSeeCount(Integer seeCount) {
        this.seeCount = seeCount;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Integer getEvaluateCount() {
        return evaluateCount;
    }

    public void setEvaluateCount(Integer evaluateCount) {
        this.evaluateCount = evaluateCount;
    }

    public BigDecimal getScore() {
        return score;
    }

    public void setScore(BigDecimal score) {
        this.score = score;
    }

    public Integer getIsFreeMan() {
        return isFreeMan;
    }

    public void setIsFreeMan(Integer isFreeMan) {
        this.isFreeMan = isFreeMan;
    }

    public String getGoodat() {
        return goodat;
    }

    public void setGoodat(String goodat) {
        this.goodat = goodat;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHeadImgURL() {
        return headImgURL;
    }

    public void setHeadImgURL(String headImgURL) {
        this.headImgURL = headImgURL;
    }

    public String getFullImgURL() {
        return fullImgURL;
    }

    public void setFullImgURL(String fullImgURL) {
        this.fullImgURL = fullImgURL;
    }

    public String getHotlinephone() {
        return hotlinephone;
    }

    public void setHotlinephone(String hotlinephone) {
        this.hotlinephone = hotlinephone;
    }

    public Date getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(Date lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public Date getPreLoginTime() {
        return preLoginTime;
    }

    public void setPreLoginTime(Date preLoginTime) {
        this.preLoginTime = preLoginTime;
    }

    public Integer getProjectId() {
        return projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public boolean isProjectAuthorized() {
        return projectAuthorized;
    }

    public void setProjectAuthorized(boolean projectAuthorized) {
        this.projectAuthorized = projectAuthorized;
    }

    public String getDeptUrlPath() {
        return deptUrlPath;
    }

    public void setDeptUrlPath(String deptUrlPath) {
        this.deptUrlPath = deptUrlPath;
    }

    public String getSetKefu() {
        return setKefu;
    }

    public void setSetKefu(String setKefu) {
        this.setKefu = setKefu;
    }

    public String getKefuAccid() {
        return kefuAccid;
    }

    public void setKefuAccid(String kefuAccid) {
        this.kefuAccid = kefuAccid;
    }

    /**
     * 获取用户名
     *
     * @return 用户名
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置用户名
     *
     * @param name 用户名
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取密码
     *
     * @return 密码
     */
    public String getPassword() {
        return this.password;
    }

    /**
     * 设置密码
     *
     * @param password 密码
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * 获取微信号
     *
     * @return 微信号
     */
    public String getWeiXinId() {
        return this.weiXinId;
    }

    /**
     * 设置微信号
     *
     * @param weiXinId 微信号
     */
    public void setWeiXinId(String weiXinId) {
        this.weiXinId = weiXinId;
    }

    /**
     * 获取成员头像的mediaid
     *
     * @return 成员头像的mediaid
     */
    public String getMediaId() {
        return this.mediaId;
    }

    /**
     * 设置成员头像的mediaid
     *
     * @param mediaId 成员头像的mediaid
     */
    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * 获取手机号
     *
     * @return 手机号
     */
    public String getMobile() {
        return this.mobile;
    }

    /**
     * 设置手机号
     *
     * @param mobile 手机号
     */
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getCornet() {
        return cornet;
    }

    public void setCornet(String cornet) {
        this.cornet = cornet;
    }

    /**
     * 获取部门编号
     *
     * @return 部门编号
     */
    public Integer getDeptId() {
        return this.deptId;
    }

    /**
     * 设置部门编号
     *
     * @param deptId 部门编号
     */
    public void setDeptId(Integer deptId) {
        this.deptId = deptId;
    }

    /**
     * 获取部门名称
     *
     * @return 部门名称
     */
    public String getDeptName() {
        return this.deptName;
    }

    /**
     * 设置部门名称
     *
     * @param deptName 部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    /**
     * 获取职位
     *
     * @return 职位
     */
    public String getPosition() {
        return this.position;
    }

    /**
     * 设置职位
     *
     * @param position 职位
     */
    public void setPosition(String position) {
        this.position = position;
    }

    /**
     * 获取1男 2女
     *
     * @return 1男 2女
     */
    public String getGender() {
        return this.gender;
    }

    /**
     * 设置1男 2女
     *
     * @param gender 1男 2女
     */
    public void setGender(String gender) {
        this.gender = gender;
    }

    /**
     * 获取邮箱
     *
     * @return 邮箱
     */
    public String getEmail() {
        return this.email;
    }

    /**
     * 设置邮箱
     *
     * @param email 邮箱
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * 获取扩展属性
     *
     * @return 扩展属性
     */
    public String getExtattr() {
        return this.extattr;
    }

    /**
     * 设置扩展属性
     *
     * @param extattr 扩展属性
     */
    public void setExtattr(String extattr) {
        this.extattr = extattr;
    }

    /**
     * 获取关注状态: 1=已关注，2=已禁用，4=未关注
     *
     * @return 关注状态: 1=已关注，2=已禁用，4=未关注
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置关注状态: 1=已关注，2=已禁用，4=未关注
     *
     * @param status 关注状态: 1=已关注，2=已禁用，4=未关注
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取1启用 0冻结
     *
     * @return 1启用 0冻结
     */
    public java.lang.Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * 设置1启用 0冻结
     *
     * @param enabled 1启用 0冻结
     */
    public void setEnabled(java.lang.Boolean enabled) {
        this.enabled = enabled;
    }

    /**
     * 获取创建人用户ID
     *
     * @return 创建人用户ID
     */
    public Integer getCreateUserid() {
        return this.createUserid;
    }

    /**
     * 设置创建人用户ID
     *
     * @param createUserid 创建人用户ID
     */
    public void setCreateUserid(Integer createUserid) {
        this.createUserid = createUserid;
    }

    /**
     * 获取创建人用户名
     *
     * @return 创建人用户名
     */
    public String getCreateUsername() {
        return this.createUsername;
    }

    /**
     * 设置创建人用户名
     *
     * @param createUsername 创建人用户名
     */
    public void setCreateUsername(String createUsername) {
        this.createUsername = createUsername;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    /**
     * 获取创建人电脑IP
     *
     * @return 创建人电脑IP
     */
    public String getCreateIp() {
        return this.createIp;
    }

    /**
     * 设置创建人电脑IP
     *
     * @param createIp 创建人电脑IP
     */
    public void setCreateIp(String createIp) {
        this.createIp = createIp;
    }

    /**
     * 获取最后一次修改人用户ID
     *
     * @return 最后一次修改人用户ID
     */
    public Integer getUpdateUserid() {
        return this.updateUserid;
    }

    /**
     * 设置最后一次修改人用户ID
     *
     * @param updateUserid 最后一次修改人用户ID
     */
    public void setUpdateUserid(Integer updateUserid) {
        this.updateUserid = updateUserid;
    }

    /**
     * 获取最后一次修改人用户名
     *
     * @return 最后一次修改人用户名
     */
    public String getUpdateUsername() {
        return this.updateUsername;
    }

    /**
     * 设置最后一次修改人用户名
     *
     * @param updateUsername 最后一次修改人用户名
     */
    public void setUpdateUsername(String updateUsername) {
        this.updateUsername = updateUsername;
    }

    /**
     * 设置最后一次修改时间字符串格式
     *
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后一次修改时间
     *
     * @return 最后一次修改时间
     */
    public Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置最后一次修改时间
     *
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取最后一次修改人电脑IP
     *
     * @return 最后一次修改人电脑IP
     */
    public String getUpdateIp() {
        return this.updateIp;
    }

    /**
     * 设置最后一次修改人电脑IP
     *
     * @param updateIp 最后一次修改人电脑IP
     */
    public void setUpdateIp(String updateIp) {
        this.updateIp = updateIp;
    }

    public String getPersonHotline() {
        return personHotline;
    }

    public void setPersonHotline(String personHotline) {
        this.personHotline = personHotline;
    }

    public String getResourceId() {
        return resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getRemotePath() {
        return remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public String getLimitLogin() {
        return limitLogin;
    }

    public void setLimitLogin(String limitLogin) {
        this.limitLogin = limitLogin;
    }

    public String getWxNumber() {
        return wxNumber;
    }

    public void setWxNumber(String wxNumber) {
        this.wxNumber = wxNumber;
    }

    public String getWxCodeImgUrl() {
        return wxCodeImgUrl;
    }

    public void setWxCodeImgUrl(String wxCodeImgUrl) {
        this.wxCodeImgUrl = wxCodeImgUrl;
    }

    public int getPromoteId() {
        return promoteId;
    }

    public void setPromoteId(int promoteId) {
        this.promoteId = promoteId;
    }

    public Integer getOnlineStatus() {
        return onlineStatus;
    }

    public void setOnlineStatus(Integer onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    public Integer getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Integer isOpen) {
        this.isOpen = isOpen;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("Name",
                getName()).append(
                "Password", getPassword()).append("WeiXinId", getWeiXinId()).append("MediaId", getMediaId()).append(
                "Mobile", getMobile()).append("DeptId", getDeptId()).append("DeptName", getDeptName()).append("Position",
                getPosition()).append(
                "Gender", getGender()).append("Email", getEmail()).append("Extattr", getExtattr()).append("Status",
                getStatus()).append(
                "Enabled", getEnabled()).append("CreateUserid", getCreateUserid()).append("CreateUsername",
                getCreateUsername()).append(
                "CreateTime", getCreateTime()).append("CreateIp", getCreateIp()).append("UpdateUserid",
                getUpdateUserid()).append(
                "UpdateUsername", getUpdateUsername()).append("UpdateTime", getUpdateTime()).append("UpdateIp",
                getUpdateIp()).append(
                        "showMobile=" + getShowMobile()
                )

                .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UserEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        UserEntity other = (UserEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

