/**
 * Description: StatusSourceStatistics数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-11-02 下午 17:54:57
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-11-02   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * StatusSourceStatistics数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-11-02
 * @see
 * @since 1.0
 */
public class StatusSourceStatisticsEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 统计对象ID
     */

    private Integer projectId;

    /**
     * 统计对象名称
     */
    @Length(max = 1000, message = "长度需要大于0且小于1000")
    private String projectName;

    /**
     * 统计对象类型 1 部门 2 职员 3 项目 4状态
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String objectType;

    /**
     * 客户状态
     */

    private Integer customerStatus;

    /**
     * 客户数量
     */

    private Integer customerNum;

    /**
     * 来源ID
     */

    private Integer sourceId;

    /**
     * 来源名称
     */
    @Length(max = 1000, message = "长度需要大于0且小于1000")
    private String sourceName;

    /**
     * 城市编码
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String city;

    /**
     * 城市名称
     */
    @Length(max = 20, message = "长度需要大于0且小于20")
    private String cityName;

    /**
     * 环比
     */

    private java.math.BigDecimal dayBaseRatio;

    /**
     * 创建时间
     */

    private java.util.Date createTime;

    //columns END
    /*
	public StatusSourceStatistics(){
	}

	public StatusSourceStatistics(
		Integer id
	){
		this.id = id;
	}

    */

    /**
     * 设置统计对象ID
     * @param projectId 统计对象ID
     */
    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * 获取统计对象ID
     * @return 统计对象ID
     */
    public Integer getProjectId() {
        return this.projectId;
    }

    /**
     * 设置统计对象名称
     * @param projectName 统计对象名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 获取统计对象名称
     * @return 统计对象名称
     */
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * 设置统计对象类型 1 部门 2 职员 3 项目 4状态
     * @param objectType 统计对象类型 1 部门 2 职员 3 项目 4状态
     */
    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    /**
     * 获取统计对象类型 1 部门 2 职员 3 项目 4状态
     * @return 统计对象类型 1 部门 2 职员 3 项目 4状态
     */
    public String getObjectType() {
        return this.objectType;
    }

    /**
     * 设置客户状态
     * @param customerStatus 客户状态
     */
    public void setCustomerStatus(Integer customerStatus) {
        this.customerStatus = customerStatus;
    }

    /**
     * 获取客户状态
     * @return 客户状态
     */
    public Integer getCustomerStatus() {
        return this.customerStatus;
    }

    /**
     * 设置客户数量
     * @param customerNum 客户数量
     */
    public void setCustomerNum(Integer customerNum) {
        this.customerNum = customerNum;
    }

    /**
     * 获取客户数量
     * @return 客户数量
     */
    public Integer getCustomerNum() {
        return this.customerNum;
    }

    /**
     * 设置来源ID
     * @param sourceId 来源ID
     */
    public void setSourceId(Integer sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * 获取来源ID
     * @return 来源ID
     */
    public Integer getSourceId() {
        return this.sourceId;
    }

    /**
     * 设置来源名称
     * @param sourceName 来源名称
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    /**
     * 获取来源名称
     * @return 来源名称
     */
    public String getSourceName() {
        return this.sourceName;
    }

    /**
     * 设置城市编码
     * @param city 城市编码
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 获取城市编码
     * @return 城市编码
     */
    public String getCity() {
        return this.city;
    }

    /**
     * 设置城市名称
     * @param cityName 城市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取城市名称
     * @return 城市名称
     */
    public String getCityName() {
        return this.cityName;
    }

    /**
     * 设置环比
     * @param dayBaseRatio 环比
     */
    public void setDayBaseRatio(java.math.BigDecimal dayBaseRatio) {
        this.dayBaseRatio = dayBaseRatio;
    }

    /**
     * 获取环比
     * @return 环比
     */
    public java.math.BigDecimal getDayBaseRatio() {
        return this.dayBaseRatio;
    }

    /**
     * 设置创建时间
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置创建时间字符串格式
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("ProjectId", getProjectId())
                .append("ProjectName", getProjectName())
                .append("ObjectType", getObjectType())
                .append("CustomerStatus", getCustomerStatus())
                .append("CustomerNum", getCustomerNum())
                .append("SourceId", getSourceId())
                .append("SourceName", getSourceName())
                .append("City", getCity())
                .append("CityName", getCityName())
                .append("DayBaseRatio", getDayBaseRatio())
                .append("CreateTime", getCreateTime())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof StatusSourceStatisticsEntity == false) return false;
        if (this == obj) return true;
        StatusSourceStatisticsEntity other = (StatusSourceStatisticsEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

