/*
 * Copyright (C), 2002-2015, 江苏三六五网络股份有限公司
 * FileName: BaseAttachment.java
 * Author:   duhui
 * Date:     2015年1月18日 下午1:59:11
 * Description:
 * History:
 * <author>      <time>      <version>    <desc>
 * 修改人姓名                          修改时间                        版本号                                 描述
 */
package com.house365.beans.entity;

import com.google.common.base.Strings;
import com.house365.beans.system.DomainObject;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 上传文件类
 *
 * @author duhui
 * @version [v1.0.0, 2015年1月18日]
 * @see [相关类/方法]（可选）
 * @since [产品/模块版本] （可选）
 */
public class BaseAttachment extends DomainObject {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 表单id
     */
    private java.lang.Integer resourceId;

    /**
     * 表单bean
     */
    @Length(max = 600)
    private java.lang.String resourceType;

    /**
     * 业务类型字段
     */
    private Integer bizType;

    /**
     * 附件名称
     */
    @Length(max = 900)
    private java.lang.String name;

    /**
     * 附件类型
     */
    private java.lang.Integer attachmentTypeId;

    /**
     * 附件后缀
     */
    @Length(max = 30)
    private java.lang.String suffix;

    /**
     * 文件大小
     */
    private Long size;

    /**
     * 文件路径
     */
    @Length(max = 500)
    private java.lang.String remotePath;

    /**
     * 文件保存路径
     */
    private java.lang.Integer remoteServerUrlid;

    /**
     * 备注
     */
    @Length(max = 100)
    private java.lang.String remark;

    private Date createTime;

    /**
     * 获取表单id
     *
     * @return 表单id
     */
    public java.lang.Integer getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    /**
     * 设置表单bean
     *
     * @param resourceType 表单bean
     */
    public void setResourceType(java.lang.String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * 获取表单bean
     *
     * @return 表单bean
     */
    public java.lang.String getResourceType() {
        return this.resourceType;
    }

    /**
     * 设置附件名称
     *
     * @param name 附件名称
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 获取附件名称
     *
     * @return 附件名称
     */
    public java.lang.String getName() {
        return this.name;
    }

    /**
     * 设置附件类型
     *
     * @param attachmentTypeId 附件类型
     */
    public void setAttachmentTypeId(java.lang.Integer attachmentTypeId) {
        this.attachmentTypeId = attachmentTypeId;
    }

    /**
     * 获取附件类型
     *
     * @return 附件类型
     */
    public java.lang.Integer getAttachmentTypeId() {
        return this.attachmentTypeId;
    }

    /**
     * 设置附件后缀
     *
     * @param suffix 附件后缀
     */
    public void setSuffix(java.lang.String suffix) {
        this.suffix = suffix;
    }

    /**
     * 获取附件后缀
     *
     * @return 附件后缀
     */
    public java.lang.String getSuffix() {
        return this.suffix;
    }

    /**
     * 设置文件大小
     *
     * @param size 文件大小
     */
    public void setSize(Long size) {
        this.size = size;
    }

    /**
     * 获取文件大小
     *
     * @return 文件大小
     */
    public Long getSize() {
        return this.size;
    }

    /**
     * 设置文件路径
     *
     * @param remotePath 文件路径
     */
    public void setRemotePath(java.lang.String remotePath) {
        this.remotePath = remotePath;
    }

    /**
     * 获取文件路径
     *
     * @return 文件路径
     */
    public java.lang.String getRemotePath() {
        return this.remotePath;
    }

    /**
     * 功能描述: <br>
     * 获取100*70尺寸图片
     *
     * @return
     * @author chengjianfang
     * @version [v1.0.0, 2015年2月4日]
     * @since [产品/模块版本](可选)
     */
    public String getX1RemotePath() {
        return getZoomRemotePath("100x70");
    }

    /**
     * 功能描述: <br>
     * 获取200*140尺寸图片
     *
     * @return
     * @author chengjianfang
     * @version [v1.0.0, 2015年2月4日]
     * @since [产品/模块版本](可选)
     */
    public String getX2RemotePath() {
        return getZoomRemotePath("200x140");
    }

    /**
     * 功能描述: <br>
     * 获取300*210尺寸图片
     *
     * @return
     * @author chengjianfang
     * @version [v1.0.0, 2015年2月4日]
     * @since [产品/模块版本](可选)
     */
    public String getX3RemotePath() {
        return getZoomRemotePath("300x210");
    }

    /**
     * 功能描述: <br>
     * 获取400*280尺寸图片
     *
     * @return
     * @author chengjianfang
     * @version [v1.0.0, 2015年2月4日]
     * @since [产品/模块版本](可选)
     */
    public String getX4RemotePath() {
        return getZoomRemotePath("400x280");
    }

    /**
     * 功能描述: <br>
     * 获取缩放路径
     *
     * @param zoomStr 缩放比例的字符串
     * @return
     * @author chengjianfang
     * @version [v1.0.0, 2015年2月4日]
     * @since [产品/模块版本](可选)
     */
    private String getZoomRemotePath(final String zoomStr) {
        if (Strings.isNullOrEmpty(remotePath)) {
            return "";
        }

        final int lastPointIndex = this.remotePath.lastIndexOf('.');
        final String fileName = this.remotePath.substring(0, lastPointIndex);
        final String suffix = this.remotePath.substring(lastPointIndex);
        StringBuffer path = new StringBuffer(fileName);
        //注释以下代码修改后台图片不显示问题 update by jiangzhou 2015-06-16
        //path.append("_");
        //path.append(zoomStr);
        path.append(suffix);
        return path.toString();
    }

    /**
     * 设置文件保存路径
     *
     * @param remoteServerUrlid 文件保存路径
     */
    public void setRemoteServerUrlid(java.lang.Integer remoteServerUrlid) {
        this.remoteServerUrlid = remoteServerUrlid;
    }

    /**
     * 获取文件保存路径
     *
     * @return 文件保存路径
     */
    public java.lang.Integer getRemoteServerUrlid() {
        return this.remoteServerUrlid;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(java.lang.String remark) {
        this.remark = remark;
    }

    /**
     * 获取备注
     *
     * @return 备注
     */
    public java.lang.String getRemark() {
        return this.remark;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }


    /**
     * @return the bizType
     */
    public Integer getBizType() {
        return bizType;
    }

    /**
     * @param bizType the bizType to set
     */
    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("ResourceId",
                                                                                                      getResourceId()).append(
            "ResourceType", getResourceType()).append("BizType", getBizType()).append("Name", getName()).append(
            "AttachmentTypeId", getAttachmentTypeId()).append("Suffix", getSuffix()).append("Size", getSize()).append(
            "RemotePath", getRemotePath()).append("RemoteServerUrlid", getRemoteServerUrlid()).append("Remark",
                                                                                                      getRemark()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof BaseAttachment == false)
            return false;
        if (this == obj)
            return true;
        BaseAttachment other = (BaseAttachment) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }

}
