package com.house365.ws.system;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.house365.beans.system.Page;


/**
 * TOP查询请求接口。
 */
public class House365SearchRequest implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 随机码
	 */
	private String randomNumber;

	/**
	 * 加密随机码
	 */
	private String encryptRandomNumber;

	/**
	 * 分页
	 */
	private Page paging = new Page();

	/**
	 * 原始查询条件
	 */
	private Map<String, Object> searchParams = new HashMap<String, Object>();

	/**
	 * 排序列
	 */
	private String orderColumn = "id";

	/**
	 * 排序方式。只允许两个值。desc和asc
	 */
	private String orderMode = "desc";
	
	/**
	 * 方法中需要带入的其他参数
	 */
	private Map<String,Object> paramMap = new HashMap<String, Object>();

	/**
	 * 可以通过该参数直接指定查询多少条。
	 */
	private int limit;

	public String getRandomNumber() {
		return randomNumber;
	}

	public void setRandomNumber(String randomNumber) {
		this.randomNumber = randomNumber;
	}

	public String getEncryptRandomNumber() {
		return encryptRandomNumber;
	}

	public void setEncryptRandomNumber(String encryptRandomNumber) {
		this.encryptRandomNumber = encryptRandomNumber;
	}

	public Page getPaging() {
		return paging;
	}

	public void setPaging(Page paging) {
		this.paging = paging;
	}

	public Map<String, Object> getSearchParams() {
		return searchParams;
	}

	public void setSearchParams(Map<String, Object> searchParams) {
		this.searchParams = searchParams;
	}

	public String getOrderColumn() {
		return orderColumn;
	}

	public void setOrderColumn(String orderColumn) {
		this.orderColumn = orderColumn;
	}

	public String getOrderMode() {
		return orderMode;
	}

	public void setOrderMode(String orderMode) {
		this.orderMode = orderMode;
	}

	public int getLimit() {
		return limit;
	}

	public void setLimit(int limit) {
		this.limit = limit;
	}
	
	public Map<String, Object> getParamMap() {
		return paramMap;
	}

	public void setParamMap(Map<String, Object> paramMap) {
		this.paramMap = paramMap;
	}

}
